import theater.*;


/**
 * Die Klasse stellt eine interne Repraesentation des Spielfeldes dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (01.10.2009)
 *
 */
class Feld implements java.io.Serializable {
    static final int MAX_LOESUNGEN = 10000;
    static final int DEF_LOESUNGEN = -1;
    static final int LEER = 0;
    private int[][] feld;
    private int loesungen;

    Feld() {
        feld = new int[9][9];

        for (int r = 0; r < 9; r++) {
            for (int s = 0; s < 9; s++) {
                feld[r][s] = LEER;
            }
        }

        loesungen = 0;
    }

    Feld(Feld f) {
        feld = new int[9][9];

        for (int r = 0; r < 9; r++) {
            for (int s = 0; s < 9; s++) {
                feld[r][s] = f.feld[r][s];
            }
        }

        loesungen = f.loesungen;
    }

    int getZahl(int reihe, int spalte) {
        return feld[reihe - 1][spalte - 1];
    }

    void setZahl(int reihe, int spalte, int zahl) {
        feld[reihe - 1][spalte - 1] = zahl;
    }

    boolean istLeer(int reihe, int spalte) {
        return feld[reihe - 1][spalte - 1] == LEER;
    }

    boolean istBelegt(int reihe, int spalte) {
        return feld[reihe - 1][spalte - 1] != LEER;
    }

    void loeschen(int reihe, int spalte) {
        feld[reihe - 1][spalte - 1] = LEER;
    }

    boolean istZugMoeglich(int reihe, int spalte, int zahl) {
        reihe = reihe - 1;
        spalte = spalte - 1;

        // Bereits belegt
        if (feld[reihe][spalte] != LEER) {
            return false;
        }

        // Spalten der gewuenschten Reihe ueberpruefen
        for (int i = 0; i < 9; i++) {
            if ((i != spalte) && (feld[reihe][i] == zahl)) {
                return false;
            }
        }

        // Reihen der gewuenschten Spalte ueberpruefen
        for (int i = 0; i < 9; i++) {
            if ((i != reihe) && (feld[i][spalte] == zahl)) {
                return false;
            }
        }

        // Quadranten ueberpruefen
        for (int r = reihe / 3 * 3; r < ((reihe / 3 * 3) + 3); r++) {
            for (int s = spalte / 3 * 3; s < ((spalte / 3 * 3) + 3); s++) {
                if (!((r == reihe) && (s == spalte)) && (feld[r][s] == zahl)) {
                    return false;
                }
            }
        }

        return true;
    }

    int getAnzahlBelegteFelder() {
        int anzahl = 0;

        for (int r = 0; r < 9; r++) {
            for (int s = 0; s < 9; s++) {
                if (feld[r][s] != LEER) {
                    anzahl++;
                }
            }
        }

        return anzahl;
    }

    int getAnzahlLoesungen() {
        Feld copy = new Feld(this);

        return copy.getAnzahlLoesungenIntern();
    }

    private int getAnzahlLoesungenIntern() {
        loesungen = 0;
        sudokus(0, 0);

        return loesungen;
    }

    private void sudokus(int reihe, int spalte) {
        if ((reihe < 0) || (spalte < 0) || (reihe > 8) || (spalte > 8)) {
            return;
        }

        if (feld[reihe][spalte] != LEER) {
            sudokus(nextR(reihe, spalte), nextS(reihe, spalte));
        } else {
            for (int i = 1; i <= 9; i++) {
                feld[reihe][spalte] = i;

                if (ok(reihe, spalte, i)) {
                    if (voll()) {
                        loesungen++;

                        if (loesungen > MAX_LOESUNGEN) {
                            loesungen = DEF_LOESUNGEN;
                        }
                    } else {
                        sudokus(nextR(reihe, spalte), nextS(reihe, spalte));
                    }
                }

                if (loesungen == DEF_LOESUNGEN) {
                    return;
                }
            }

            feld[reihe][spalte] = 0;
        }
    }

    Feld loesen() throws SudokuException {
        Feld store = new Feld(this);
        loesungen = 0;

        Feld result = null;
        sudoku(0, 0);

        if (loesungen > 0) {
            result = new Feld(this);
        }

        this.feld = store.feld;

        return result;
    }

    private void sudoku(int reihe, int spalte) {
        if ((reihe < 0) || (spalte < 0) || (reihe > 8) || (spalte > 8)) {
            return;
        }

        if (feld[reihe][spalte] != LEER) {
            sudoku(nextR(reihe, spalte), nextS(reihe, spalte));
        } else {
            for (int i = 1; i <= 9; i++) {
                feld[reihe][spalte] = i;

                if (ok(reihe, spalte, i)) {
                    if (voll()) {
                        loesungen++;
                    } else {
                        sudoku(nextR(reihe, spalte), nextS(reihe, spalte));
                    }
                }

                if (loesungen > 0) {
                    return;
                }
            }

            feld[reihe][spalte] = 0;
        }
    }

    private int nextR(int reihe, int spalte) {
        if (spalte < 8) {
            return reihe;
        } else {
            return reihe + 1;
        }
    }

    private int nextS(int reihe, int spalte) {
        if (spalte < 8) {
            return spalte + 1;
        } else {
            return 0;
        }
    }

    private boolean ok(int reihe, int spalte, int wert) {
        for (int i = 0; i < 9; i++) {
            if ((i != spalte) && (feld[reihe][i] == wert)) {
                return false;
            }
        }

        for (int i = 0; i < 9; i++) {
            if ((i != reihe) && (feld[i][spalte] == wert)) {
                return false;
            }
        }

        for (int r = reihe / 3 * 3; r < ((reihe / 3 * 3) + 3); r++) {
            for (int s = spalte / 3 * 3; s < ((spalte / 3 * 3) + 3); s++) {
                if (!((r == reihe) && (s == spalte)) && (feld[r][s] == wert)) {
                    return false;
                }
            }
        }

        return true;
    }

    private boolean voll() {
        for (int i = 0; i < 9; i++) {
            for (int j = 0; j < 9; j++) {
                if (feld[i][j] == 0) {
                    return false;
                }
            }
        }

        return true;
    }

    public String toString() {
        String res = "";

        for (int i = 0; i < 9; i++) {
            for (int j = 0; j < 9; j++) {
                res += (feld[i][j] + " ");
            }

            res += "\n";
        }

        return res;
    }
}
