import theater.*;


/**
 * Die Klasse stellt eine Repraesentation eines Baumstumpfes dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (04.11.2009)
 */
public class Baumstumpf extends Prop {
    public Baumstumpf() {
        setImage("baumstumpf.gif");
        setZCoordinate(3);
    }

    @Invisible
    public void addedToStage(Stage stage) {
        ((Landschaft) getStage()).adaptView();
    }

    @Invisible
    public void setLocation(int col, int row) {
        if ((this.getColumn() == col) && (this.getRow() == row)) {
            return;
        }

        Landschaft landschaft = (Landschaft) getStage();

        col = landschaft.calcColumn(col);

        row = landschaft.calcRow(row);

        if ((this.getColumn() == col) && (this.getRow() == row)) {
            return;
        }

        // Tile has to be empty
        if (getStage().getComponentsAt(col, row).size() > 0) {
            return;
        }

        super.setLocation(col, row);
        ((Landschaft) getStage()).adaptView();
    }
}
