import theater.*;


/**
 * Die Klasse stellt eine Repraesentation eines Kleeblattes dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (04.11.2009)
 */
public class Kleeblatt extends Prop {
    public Kleeblatt() {
        setImage("kleeblatt.gif");
        setZCoordinate(1);
    }

    @Invisible
    public void addedToStage(Stage stage) {
        ((Landschaft) getStage()).adaptView();
    }

    @Invisible
    public void setLocation(int col, int row) {
        if ((this.getColumn() == col) && (this.getRow() == row)) {
            return;
        }

        Landschaft landschaft = (Landschaft) getStage();

        col = landschaft.calcColumn(col);

        row = landschaft.calcRow(row);

        if ((this.getColumn() == col) && (this.getRow() == row)) {
            return;
        }

        // no Baumstumpf or Kleeblatt allowed
        if (getStage()
                    .getComponentsAt(col, row, Baumstumpf.class, Kleeblatt.class)
                    .size() > 0) {
            return;
        }

        super.setLocation(col, row);
        ((Landschaft) getStage()).adaptView();
    }
}
