import theater.*;

import java.util.List;


/**
 * Repraesentation von Mauern im Java-Hamster-Modell
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (17.07.2009)
 *
 */
public class Mauer extends Prop {
    // Default-Konstruktor. Wird aufgerufen, wenn eine Mauer erzeugt wird.
    public Mauer() {
        // festlegen des Ikons fr eine Mauer
        this.setImage("mauer.png");
    }

    // Wird aufgerufen, nachdem eine Mauer auf der Bhne platziert wurde.
    @Invisible // soll nicht im Popup-Men erscheinen

    public void addedToStage(Stage stage) {
        Performance.getPerformance().lock();

        try {
            // lscht alle Komponenten, die sich auf derselben Zelle der Bhne 
            // befinden
            this.removeComponentsOnCell(this.getColumn(), this.getRow());
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    // Platziert die Mauer auf der Bhne um. bergeben werden die neue Spalte und Reihe.
    // Die Methode wird auch aufgerufen,
    // wenn eine Mauer per Mausklick auf der Bhne verschoben wird.
    // berschreibt die entsprechende Component-Methode.
    @Invisible // soll nicht im Popup-Men erscheinen

    public void setLocation(int col, int row) {
        Performance.getPerformance().lock();

        try {
            if ((this.getColumn() == col) && (this.getRow() == row)) {
                // Mauer befindet sich bereits auf dieser Zelle
                return;
            }

            if ((col < 0) || (row < 0) ||
                    (col >= this.getStage().getNumberOfColumns()) ||
                    (row >= this.getStage().getNumberOfRows())) {
                // nur innerhalb der sichtbaren Bhne 
                return;
            }

            Actor solist = getStage().getSolist();

            if ((col == solist.getColumn()) && (row == solist.getRow())) {
                // Mauer kann nicht auf die Zelle umplatziert werden, auf der
                // sich der Solist befindet
                return;
            }

            // Mauer auf Kachel?
            if (this.getStage().getComponentsAt(col, row, Mauer.class).size() > 0) {
                // eine Mauer kann nicht auf eine Kachel platziert werden, auf der sich
                // bereits eine Mauer befindet
                return;
            }

            // lscht alle Komponenten, die sich auf derselben Zelle der Bhne 
            // befinden
            this.removeComponentsOnCell(col, row);

            // ruft die geerbte Methode auf, die die tatschliche Umplatzierung
            // vornimmt
            super.setLocation(col, row);
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    // entfernt die Komponenten der bergebenen Zelle von der Bhne
    @Invisible // soll nicht im Popup-Men erscheinen

    private void removeComponentsOnCell(int col, int row) {
        // ermittelt alle Komponenten der Zelle
        List<Component> comps = this.getStage().getComponentsAt(col, row);

        for (Component comp : comps) {
            if (comp != this) {
                // die Mauer selbst wird (natrlich) nicht entfernt
                this.getStage().remove(comp);
            }
        }
    }
}
