import theater.*;

import java.util.List;


/**
 * Repraesentation von Koernern im Java-Hamster-Modell
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (17.07.2009)
 *
 */
public class Korn extends Prop {
    // speichert die tatschliche Anzahl an Krnern auf einer Zelle
    private int anzahl;

    // Default-Konstruktor. Wird aufgerufen, wenn ein Korn erzeugt wird.
    public Korn() {
        this(1);
    }

    // ber diesen Konstruktor knnen mehrere Krner gleichzeitig erzeugt werden
    public Korn(int anzahl) {
        setImage("korn.png");
        this.anzahl = anzahl;
    }

    // wird aufgerufen, wenn das Korn in das Territorium platziert wird
    @Invisible // soll nicht im Popup-Men erscheinen

    public void addedToStage(Stage stage) {
        Performance.getPerformance().lock();

        try {
            // Wenn auf der Kachel schon eine Mauer ist, wird das Korn direkt wieder
            // entfernt
            List<Component> mauer = this.getStage()
                                        .getComponentsAt(this.getColumn(),
                    this.getRow(), Mauer.class);

            if (mauer.size() > 0) {
                this.getStage().remove(this);

                return;
            }

            // bereits Korn auf Kachel?
            List<Component> koerner = this.getStage()
                                          .getComponentsAt(this.getColumn(),
                    this.getRow(), Korn.class);

            if (koerner.size() > 1) {
                // es befindet sich bereits mindestens ein anderes Korn auf der Kachel
                Korn korn = (Korn) koerner.get(0);

                if (korn == this) {
                    korn = (Korn) koerner.get(1);
                }

                // das alte Korn wird entfernt
                this.getStage().remove(korn);

                // Anzahl der Krner wir dum 1 erhht
                this.anzahl += korn.anzahl;
            }

            // das gesetzte Ikon spiegelt die Anzahl an Krnern wider (max. 12)
            this.setImage("korn" + Math.min(this.anzahl, 12) + ".png");
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    // liefert die Information, das wie vielte Korn dieses Korn auf der Kachel
    // ist
    @Invisible // soll nicht im Popup-Men erscheinen

    protected int getAnzahl() {
        return this.anzahl;
    }

    // Platziert ein Korn auf der Bhne um. bergeben werden die neue Spalte und Reihe.
    // Die Methode wird auch aufgerufen,
    // wenn ein Korn per Mausklick auf der Bhne verschoben wird.
    // berschreibt die entsprechende Component-Methode.
    @Invisible // soll nicht im Popup-Men erscheinen

    public void setLocation(int col, int row) {
        Performance.getPerformance().lock();

        try {
            if ((this.getColumn() == col) && (this.getRow() == row)) {
                // Korn befindet sich bereits auf dieser Zelle
                return;
            }

            if ((col < 0) || (row < 0) ||
                    (col >= this.getStage().getNumberOfColumns()) ||
                    (row >= this.getStage().getNumberOfRows())) {
                // nur innerhalb der sichtbaren Bhne 
                return;
            }

            // Mauer auf Kachel?
            if (this.getStage().getComponentsAt(col, row, Mauer.class).size() > 0) {
                // ein Korn kann nicht auf eine Kachel umplatziert werden, auf der sich
                // bereits eine Mauer befindet
                return;
            }

            // bereits Korn auf Kachel?
            List<Component> koerner = this.getStage()
                                          .getComponentsAt(col, row, Korn.class);

            if (koerner.size() > 0) {
                // altes Korn entfernen
                Korn korn = (Korn) koerner.get(0);
                this.getStage().remove(korn);
                this.anzahl += korn.anzahl;

                // das gesetzte Ikon spiegelt die Anzahl an Krnern wider (max. 12)
                this.setImage("korn" + Math.min(this.anzahl, 12) + ".png");
            }

            // ruft die geerbte Methode auf, die die tatschliche Umplatzierung
            // vornimmt
            super.setLocation(col, row);
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    // wird von der Klasse Hamster aufgerufen, wenn der Hamster ein Korn nimmt (n == -1)
    // oder gibt (n == 1)
    @Invisible // soll nicht im Popup-Men erscheinen

    void inkAnzahl(int n) {
        this.anzahl += n;

        if (this.anzahl <= 0) {
            // kein KOrn mehr vorhanden
            this.getStage().remove(this);
        } else {
            // Ikon mit vernderter Anzahl an Krnern
            this.setImage("korn" + Math.min(this.anzahl, 12) + ".png");
        }
    }
}
