import theater.*;

import java.awt.Color;


/**
 * Die Klasse stellt eine Repraesentation einer Zelle dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (05.10.2009)
 *
 */
public class Zelle extends Prop {
    // alle Zellen besitzen dasselbe Image
    private static TheaterImage image;

    static {
        image = new TheaterImage(Spielfeld.CELLSIZE, Spielfeld.CELLSIZE);
        image.setColor(Color.GRAY); // Defaultfarbe
        image.fill();
    }

    Zelle() {
        setImage(image);
    }

    @Invisible
    public void setLocation(int col, int row) {
        if (getStage().getComponentsAt(col, row, Zelle.class).size() >= 1) {
            return; // bereits eine Zelle da
        }

        super.setLocation(col, row);
    }

    // Farbe der lebenden Zellen abfragen
    @Invisible
    static Color getColor() {
        return image.getColor();
    }

    // Farbe aller lebenden Zellen ndern
    @Invisible
    static void setColor(Color color) {
        Performance.getPerformance().lock();
        Performance.getPerformance().freeze();

        try {
            // ndert die Farbe aller Zellen (auer evtl. resetteten :-()
            image.setColor(color);
            image.fill();
        } finally {
            Performance.getPerformance().unfreeze();
            Performance.getPerformance().unlock();
        }
    }
}
