import theater.*;

import java.awt.Color;
import java.awt.Font;

import javax.swing.JPanel;


/**
 * Die Klasse stellt eine Repraesentation des virtuellen Spielers dar
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (01.10.2009)
 *
 */
public class Zahl extends Prop {
    private int zahl;

    Zahl(int zahl) {
        this.zahl = zahl;
        makeImage();
    }

    Zahl(Zahl zahl) {
        this.zahl = zahl.zahl;
        makeImage();
    }

    @Invisible
    void makeImage() {
        int WIDTH = 40;
        int HEIGHT = 40;
        TheaterImage image = new TheaterImage(WIDTH, HEIGHT);
        image.setColor(Color.DARK_GRAY);

        Font font = new Font("Monospaced", Font.BOLD, 48);
        image.setFont(font);

        String z = "" + this.zahl;
        image.drawString(z,
            (image.getWidth() / 2) - (Metrics.stringWidth(z, font) / 2),
            (image.getHeight() / 2) + (Metrics.getHeight(font) / 4));
        setImage(image);
    }

    @Invisible
    public void setLocation(int col, int row) {
        Performance.getPerformance().lock();

        try {
            if ((col == getColumn()) && (row == getRow())) {
                return;
            }

            if ((col < 0) || (row < 0) || (col > 8) || (row > 8)) {
                return;
            }

            Feld feld = ((Spielfeld) getStage()).getFeld();

            if ((getRow() >= 0) && (getColumn() >= 0)) { // bereits auf dem Feld
                feld.loeschen(getRow() + 1, getColumn() + 1);

                if (feld.istZugMoeglich(row + 1, col + 1, zahl)) {
                    feld.setZahl(row + 1, col + 1, zahl);
                    super.setLocation(col, row);
                } else {
                    // zurck
                    feld.setZahl(getRow() + 1, getColumn() + 1, this.zahl);
                }
            } else { // neu

                if (feld.istZugMoeglich(row + 1, col + 1, zahl)) {
                    feld.setZahl(row + 1, col + 1, zahl);
                    super.setLocation(col, row);
                }
            }
        } finally {
            Performance.getPerformance().unlock();
        }
    }
}


// Hilfsklasse zur Berechnung der Breite eines Strings
class Metrics {
    static JPanel p = new JPanel();

    static int stringWidth(String str, Font font) {
        return p.getFontMetrics(font).stringWidth(str);
    }

    static int getHeight(Font font) {
        return p.getFontMetrics(font).getHeight();
    }
}
