public class Vector implements java.io.Serializable {
    private double x;
    private double y;

    public Vector(double direction, double length) {
        direction = correctDirection(direction);
        x = length * Math.cos(Math.toRadians(direction));
        y = length * Math.sin(Math.toRadians(direction));
    }

    public Vector(Vector v) {
        x = v.x;
        y = v.y;
    }

    public double getX() {
        return x;
    }

    public double getY() {
        return y;
    }

    public double getLength() {
        return Math.sqrt(Math.pow(x, 2) + Math.pow(y, 2));
    }

    public double getDirection() {
        double degrees = Math.toDegrees(Math.atan(y / x));

        if (x < 0) {
            return (270 + degrees) % 360;
        } else {
            return (90 + degrees) % 360;
        }
    }

    public void add(Vector rhs) {
        x += rhs.x;
        y += rhs.y;
    }

    public void verticalFlip() {
        x = -x;
    }

    public void horizontalFlip() {
        y = -y;
    }

    private void incrLength(double factor) {
        double oldSpeed = Math.sqrt(Math.pow(x, 2) + Math.pow(y, 2));
        double newSpeed = oldSpeed * factor;
        double newX = Math.sqrt(Math.pow(newSpeed, 2) - Math.pow(y, 2));
        double newY = Math.sqrt(Math.pow(newSpeed, 2) - Math.pow(x, 2));

        if (x < 0) {
            x = -newX;
        } else {
            x = newX;
        }

        if (y < 0) {
            y = -newY;
        } else {
            y = newY;
        }
    }

    private static double correctDirection(double direction) {
        double dir = direction - 90;

        if (dir < 0) {
            dir = 360 + dir;
        }

        return dir;
    }
}
