import theater.*;

import java.util.List;


public class Space extends Stage {
    public final static int WIDTH = 560;
    public final static int HEIGHT = 400;

    public Space() {
        super(WIDTH, HEIGHT, 1);
        setBackground("space.gif");
        setSolist(Actor.createSolist(), 300, 200);
    }

    public void performArtifacts() {
        List<Component> comps = getComponents(Bullet.class);

        for (Component comp : comps) {
            ((Bullet) comp).act();
        }

        comps = getComponents(Asteroid.class);

        for (Component comp : comps) {
            ((Asteroid) comp).act();
        }
    }

    public void death() {
        List<Component> comps = getComponents(Explosion.class);

        while (comps.size() > 0) {
            ((Explosion) comps.get(0)).act();
            comps = getComponents(Explosion.class);
        }
    }
}
