import theater.*;


public abstract class MovingThing extends Artifact {
    protected Vector speed;
    protected double x;
    protected double y;

    public MovingThing(Vector speed) {
        this.speed = speed;
        x = 0;
        y = 0;
    }

    public abstract void move();

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
        super.setLocation((int) x, (int) y);
    }

    public void setLocation(int x, int y) {
        setLocation((double) x, (double) y);
    }

    public Vector getMovementVector() {
        return new Vector(speed);
    }
}
