import theater.*;

import java.util.*;


public class Explosion extends Prop {
    /** How many images should be used in the animation of the explostion */
    private final static int IMAGE_COUNT = 8;

    /**
     * The images in the explosion. This is static so the images are not
     * recreated for every object (improves performance significantly).
     */
    private static TheaterImage[] images;

    static {
        TheaterImage baseImage = new TheaterImage("explosion.gif");
        int maxSize = baseImage.getWidth() / 2;
        int delta = maxSize / (IMAGE_COUNT + 1);
        int size = 0;
        images = new TheaterImage[IMAGE_COUNT];

        for (int i = 0; i < IMAGE_COUNT; i++) {
            size = size + delta;
            images[i] = new TheaterImage(baseImage);
            images[i].scale(size, size);
        }
    }

    /** Current size of the explosion */
    private int imageNo;

    /** How much do we increment the index in the explosion animation. */
    private int increment = 1;

    public Explosion() {
        imageNo = 0;
        setImage(images[imageNo]);
        Performance.getPerformance().playSound("explosion.wav");
    }

    /**
     * EXPLODE!
     */
    public void act() {
        if (imageNo > 0) {
            setImage(images[imageNo]);
        }

        imageNo += increment;

        if (imageNo >= IMAGE_COUNT) {
            increment = -increment;
            imageNo += increment;
        }

        if (imageNo < 0) {
            getStage().remove(this);
        }
    }
}
