import theater.*;

import java.util.List;


public class Bullet extends MovingThing {
    private int life;

    public Bullet(Rocket rocket) {
        super(new Vector(rocket.getMovementVector().getDirection(),
                rocket.getMovementVector().getLength() * 1.5));
        setRotation(rocket.getRotation());
        setImage("bullet.gif");
        life = 30;
        Performance.getPerformance().playSound("energygun.wav");
    }

    @Override
    public void act() {
        move();
    }

    @Override
    public void move() {
        life--;

        if (life < 0) {
            getStage().remove(this);

            return;
        }

        double newX = x + speed.getX();
        double newY = y + speed.getY();

        if ((newX < 0) || (newX >= stage.getNumberOfColumns()) || (newY < 0) ||
                (newY >= stage.getNumberOfRows())) {
            stage.remove(this);
        } else {
            x = newX;
            y = newY;
            setLocation(x, y);
            checkCollisions();
        }
    }

    private void checkCollisions() {
        List<Component> comps = stage.getIntersectingComponents(this,
                Asteroid.class);

        if (comps.size() > 0) {
            Component comp = comps.get(0);
            int col = comp.getColumn();
            int row = comp.getRow();
            stage.remove(comp);
            stage.remove(this);
        }
    }
}
