import theater.*;


public class Asteroid extends MovingThing {

    public Asteroid() {
        super(new Vector((new java.util.Random()).nextInt(360), 2.0));
        setImage("rock.gif");
    }

    @Override
    public void act() {
        move();
    }

    @Override
    public void move() {
        double newX = x + speed.getX();
        double newY = y + speed.getY();

        if ((newX < 0) || (newX >= stage.getNumberOfColumns())) {
            this.speed.verticalFlip();
            move();
        } else if ((newY < 0) || (newY >= stage.getNumberOfRows())) {
            this.speed.horizontalFlip();
            move();
        } else {
            x = newX;
            y = newY;
            setLocation(x, y);
        }
    }
}
