import theater.*;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.util.List;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;


/**
 * ActionHandler zur Aenderung der Buehnengroesse
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (04.11.2009)
 */
public class Landschaftsgroesse extends ActionHandler {
    public void handleAction(Stage stage, Actor solist) {
        SizeDialog dialog = new SizeDialog(stage);
        dialog.setVisible(true);
    }
}


class SizeDialog extends JDialog {
    JTextField reihen;
    JTextField spalten;
    Stage stage;

    public SizeDialog(Stage stage) {
        super((Frame) null, "Landschaftsgre", true);
        this.stage = stage;

        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        this.setLayout(new BorderLayout());

        JPanel rPanel = new JPanel();
        rPanel.setLayout(new FlowLayout());

        JLabel nR = new JLabel("Reihen: ");
        rPanel.add(nR);
        this.reihen = new JTextField(15);
        this.reihen.setText("" + stage.getNumberOfRows());
        this.reihen.addActionListener(new OKButtonAction(this));
        rPanel.add(this.reihen);
        this.add(rPanel, BorderLayout.NORTH);

        JPanel sPanel = new JPanel();
        sPanel.setLayout(new FlowLayout());

        JLabel nS = new JLabel("Spalten: ");
        sPanel.add(nS);
        this.spalten = new JTextField(15);
        this.spalten.setText("" + stage.getNumberOfColumns());
        this.spalten.addActionListener(new OKButtonAction(this));
        sPanel.add(this.spalten);
        this.add(sPanel, BorderLayout.CENTER);

        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER));

        JButton ok = new JButton("Ok");
        ok.addActionListener(new OKButtonAction(this));
        buttonPanel.add(ok);

        JButton cancel = new JButton("Abbrechen");
        cancel.addActionListener(new CancelButtonAction(this));
        buttonPanel.add(cancel);
        this.add(buttonPanel, BorderLayout.SOUTH);

        this.pack();
        this.setResizable(false);

        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width / 2) - (this.getWidth() / 2),
            (d.height / 2) - (this.getHeight() / 2));
    }
}


class OKButtonAction implements ActionListener {
    SizeDialog dialog;

    OKButtonAction(SizeDialog d) {
        this.dialog = d;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            int spalten = new Integer(dialog.spalten.getText());
            int reihen = new Integer(dialog.reihen.getText());

            if (spalten < 1) {
                spalten = 1;
            }

            if (reihen < 1) {
                reihen = 1;
            }

            Actor solist = dialog.stage.getSolist();

            if ((solist.getRow() >= reihen) || (solist.getColumn() >= spalten)) {
                // Solist ist auerhalb der neuen Bhne; er wird auf
                // die Kachel (0/0) umplatziert, wobei dort unter Umstnden
                // noch ein Baumstumpf oder ein Pilz entfernt werden muss
                List<Component> comps = dialog.stage.getComponentsAt(0, 0,
                        Baumstumpf.class, Pilz.class);
                dialog.stage.remove(comps);
                dialog.stage.getSolist().setLocation(0, 0);
            }

            dialog.stage.setSize(spalten, reihen);
            this.dialog.dispose();
        } catch (NumberFormatException exc) {
        }
    }
}


class CancelButtonAction implements ActionListener {
    JDialog dialog;

    CancelButtonAction(JDialog d) {
        this.dialog = d;
    }

    public void actionPerformed(ActionEvent e) {
        this.dialog.dispose();
    }
}
