import theater.*;

import java.awt.Color;


/**
 * Repraesentation einer Scheibe
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (30.09.2009)
 *
 */
public class Scheibe extends Prop {
    final static int HOEHE = 20;
    final static Color[] colors = {
            Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW, Color.MAGENTA,
            Color.PINK, Color.GRAY, Color.CYAN, Color.ORANGE,
        };
    private boolean setLocErlaubt;
    private int nummer;

    Scheibe(int i) {
        this.nummer = i;
        this.setLocErlaubt = true;

        TheaterImage image = new TheaterImage(40 + (20 * (i - 1)), HOEHE);
        image.setColor(colors[i - 1]);
        image.fillRect(0, 0, 40 + (20 * (i - 1)), HOEHE);
        setImage(image);
    }

    @Invisible
    public void addedToStage(Stage stage) {
        this.setLocErlaubt = false;
    }

    @Invisible
    int liefereNummer() {
        return nummer;
    }

    @Invisible
    void setLoc(int col, int row) {
        setLocErlaubt = true;
        setLocation(col, row);
        setLocErlaubt = false;
    }

    @Invisible
    public void setLocation(int col, int row) {
        if (setLocErlaubt) {
            super.setLocation(col, row);
        }
    }
}
