import theater.*;

/**
 * Die Klasse stellt eine Repraesentation der Krbisse dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (29.09.2009)
 *
 */
public class Kuerbis extends Prop {
    private TheaterImage image;
    private int width;
    private int height;

    public Kuerbis() {
        image = new TheaterImage("kuerbis.gif");
        setImage(image);
        width = getImage().getWidth();
        height = getImage().getHeight();
    }

    @Invisible
    public void setLocation(int col, int row) {
        Performance.getPerformance().lock();

        try {
            if ((col < 0) || (row < 0) ||
                    (col >= this.getStage().getNumberOfColumns()) ||
                    (row >= this.getStage().getNumberOfRows())) {
                // nur innerhalb der sichtbaren Bhne 
                return;
            }

            super.setLocation(col, row);
            checkKuerbisSize(col, row);
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    // der Krbis wird vergrert dargestellt, wenn sich das Mdchen 
    // oberhalb von ihm, also auf derselben Kachel, befindet
    @Invisible
    void checkKuerbisSize(int col, int row) {
        Performance.getPerformance().lock();

        try {
            if ((this.getColumn() == col) && (this.getRow() == row) &&
                    (getStage().getComponentsAt(col, row, Maedchen.class).size() > 0)) {
                image.scale((int) (width * 1.5), (int) (height * 1.5));
            } else {
                image.scale(width, height);
            }
        } finally {
            Performance.getPerformance().unlock();
        }
    }
}
