import theater.*;


/**
 * Die Klasse stellt eine Repraesentation des Frchte-Territoriums dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (22.10.2009)
 *
 */
public class World extends Stage {
    private Counter capCounter = null;
    private Counter notCounter = null;
    private long seed = 0;

    public World() {
        super(600, 400, 1);
        setBackground("garten.gif");

        setSolist(Actor.createSolist(), getNumberOfColumns() / 2, 0);

        init();
    }

    void init() {
        remove(getComponents(Counter.class));
        capCounter = new Counter();
        add(capCounter, 541, 68);
        notCounter = new Counter();
        add(notCounter, 80, 55);
    }

    Counter getCapturedCounter() {
        return capCounter;
    }

    Counter getNotCapturedCounter() {
        return notCounter;
    }
    
    void setSeed(long s) {
        seed = s;
    }
    
    long getSeed() {
        return seed;
    }
}
