import theater.*;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;


/**
 * Die Klasse stellt eine Repraesentation einer Frucht dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (22.10.2009)
 *
 */
public class FruitProp extends Prop {
    final static int N_RANDOM = 80;
    final static int N_FRUITS = 7;
    static int BOTTOM_ROW = 0;
    static Random random = new Random();
    static ArrayList<FruitProp> falling = new ArrayList<FruitProp>();
    static int notCapturedFruits = 0;
    boolean setLocPossible;

    FruitProp(int number) {
        setImage("frucht" + number + ".gif");
        setZCoordinate(2);
        setLocPossible = true;
    }

    @Invisible
    @Override
    public void addedToStage(Stage stage) {
        setLocPossible = false;
    }

    @Invisible
    static void init(long seed) {
        if (seed == 0) {
            random = new Random();
        } else {
            random = new Random(seed);
        }

        falling = new ArrayList<FruitProp>();

        Stage stage = Performance.getPerformance().getActiveStage();
        stage.remove(stage.getComponents(FruitProp.class));
        stage.getSolist()
             .setLocation(random.nextInt(stage.getNumberOfColumns()),
            stage.getSolist().getRow());
        BOTTOM_ROW = stage.getNumberOfRows();
        notCapturedFruits = 0;
    }

    @Invisible
    static ArrayList<FruitProp> getFallingFruits() {
        return falling;
    }

    @Invisible
    static void downCycle() {
        World world = (World) Performance.getPerformance().getActiveStage();
        Trolley wagen = (Trolley) world.getSolist();

        Iterator<FruitProp> iter = falling.iterator();

        while (iter.hasNext()) {
            FruitProp f = iter.next();
            f.setLoc(f.getColumn(), f.getRow() + 1);

            if (f.getRow() == BOTTOM_ROW) { // check bottom
                iter.remove();
                notCapturedFruits++;
                world.getNotCapturedCounter().add(1);
            }
        }

        // new fruit
        if (random.nextInt(N_RANDOM) == 0) {
            FruitProp f = new FruitProp(random.nextInt(N_FRUITS));
            world.add(f, random.nextInt(world.getNumberOfColumns()), 0);
            falling.add(f);
        }
    }

    @Invisible
    static FruitProp tryCapture() throws RuntimeException {
        World world = (World) Performance.getPerformance().getActiveStage();
        Trolley trolley = (Trolley) world.getSolist();

        Iterator<FruitProp> iter = falling.iterator();

        while (iter.hasNext()) {
            FruitProp f = iter.next();

            if ((f.getColumn() == trolley.getColumn()) &&
                    (f.getRow() == trolley.getRow())) { // check intersection
                iter.remove();

                return f;
            }
        }

        throw new RuntimeException("No fruit to capture.");
    }

    @Invisible
    static int getNotCapturedFruits() {
        return notCapturedFruits;
    }

    @Invisible
    void setLoc(int col, int row) {
        setLocPossible = true;
        setLocation(col, row);
        setLocPossible = false;
    }

    @Invisible
    @Override
    public void setLocation(int col, int row) {
        if (!setLocPossible &&
                ((GPerformance) Performance.getPerformance()).isRunning()) {
            return;
        }

        super.setLocation(col, row);
    }
}
