import theater.*;

import javax.swing.*;


/**
 * ActionHandler zum ndern der Spielfeldgre
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (07.10.2009)
 *
 */
public class SpielfeldGroesse extends ActionHandler {
    public void handleAction(Stage stage, Actor solist) {
        MyPerformance perf = (MyPerformance) Performance.getPerformance();

        // whrend eine Simulation luft, kann die Aktion nicht ausgefhrt werden
        if (perf.isRunning()) {
            return;
        }

        Spielfeld feld = (Spielfeld) stage;
        int oldSize = feld.getSize();
        String eingabe = JOptionPane.showInputDialog(null, "Spielfeldgre",
                oldSize);

        if (eingabe == null) { // abbrechen

            return;
        }

        int newSize = Spielfeld.MIN_SIZE;

        try {
            newSize = Integer.parseInt(eingabe);

            if (newSize > Spielfeld.MAX_SIZE) {
                newSize = Spielfeld.MAX_SIZE;
            } else if (newSize < Spielfeld.MIN_SIZE) {
                newSize = Spielfeld.MIN_SIZE;
            }
        } catch (NumberFormatException exc) {
            return; // keine nderung
        }

        feld.setSize(newSize);

        // Damen auerhalb der neuen Spielfeldgrenzen lschen
        for (int r = newSize; r < Spielfeld.MAX_SIZE; r++) {
            for (int s = 0; s < Spielfeld.MAX_SIZE; s++) {
                feld.remove(feld.getComponentsAt(s, r, Dame.class));
                feld.removeDame(r, s);
            }
        }

        for (int s = newSize; s < Spielfeld.MAX_SIZE; s++) {
            for (int r = 0; r < Spielfeld.MAX_SIZE; r++) {
                feld.remove(feld.getComponentsAt(s, r, Dame.class));
                feld.removeDame(r, s);
            }
        }
    }
}
