package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

import model.Play;
import util.IO;
import util.ResourceManager;
import util.Utils;

import compiler.CompileManager;

/**
 * Listener zum Erzeugen einer neuen Klasse
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class NewClassListener implements ActionListener {

	private JTree fileTree;
	private Play play;

	public NewClassListener(JTree tree) {
		this.fileTree = tree;
		this.play = null;
	}

	public void actionPerformed(ActionEvent e) {

		this.play = Play.getPlay();

		DefaultMutableTreeNode node = (DefaultMutableTreeNode) this.fileTree
				.getLastSelectedPathComponent();
		Object uo = node.getUserObject();
		String input = JOptionPane.showInputDialog(ResourceManager
				.getResourceManager().getValue("newclass.name"));
		if (input == null) {
			return;
		}
		while (!Utils.checkClassName(input)) {
			JOptionPane.showMessageDialog(Play.getPlay().getPlayFrame(),
					ResourceManager.getResourceManager().getValue(
							"msg.invalidname"), ResourceManager
							.getResourceManager().getValue("msg.error"),
					JOptionPane.ERROR_MESSAGE);
			input = JOptionPane.showInputDialog(ResourceManager
					.getResourceManager().getValue("newclass.name"), input);
			if (input == null) {
				return;
			}
		}
		if (uo.toString().equals(Play.STAGE)) {
			this.createNewStageClass(input);
		} else if (uo.toString().equals(Play.ACTOR)) {
			this.createNewActorClass(input);
		} else if (uo.toString().equals(Play.PROP)) {
			this.createNewPropClass(input);
		} else if (uo.toString().equals(Play.PERFORMANCE)) {
			this.createNewPerformanceClass(input);
		} else if (uo.toString().equals(Play.OTHER)) {
			this.createNewOtherClass(input);
		}

		DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(input);
		((DefaultTreeModel) this.fileTree.getModel()).insertNodeInto(childNode,
				node, node.getChildCount());
		this.fileTree.scrollPathToVisible(new TreePath(childNode.getPath()));

		CompileManager.getCompileManager().setCompilationRequired(true);

		this.play.getPlayFrame().getMessagePanel().writeInfo(
				ResourceManager.getResourceManager().getValue("msg.newclass"));
	}

	private void createNewStageClass(String name) {
		try {
			File file = new File(this.play.getDirectory() + File.separatorChar
					+ name + ".java");
			file.createNewFile();
			IO.copyResTextFile("Stage.txt", file.getAbsolutePath(), name);
			this.play.insertStageClass(name);
			if (this.play.getStageClasses().size() == 1) {
				this.play.setActiveStageName(name);
				CompileManager.getCompileManager().compile(this.play);
				this.play.reset();
			}
		} catch (Throwable exc) {
			exc.printStackTrace();
		}
	}

	private void createNewActorClass(String name) {
		try {
			File file = new File(this.play.getDirectory() + File.separatorChar
					+ name + ".java");
			file.createNewFile();
			IO.copyResTextFile("Actor.txt", file.getAbsolutePath(), name);
			this.play.insertActorClass(name);
		} catch (Throwable exc) {
			exc.printStackTrace();
		}
	}

	private void createNewPropClass(String name) {
		try {
			File file = new File(this.play.getDirectory() + File.separatorChar
					+ name + ".java");
			file.createNewFile();
			IO.copyResTextFile("Prop.txt", file.getAbsolutePath(), name);
			this.play.insertPropClass(name);
		} catch (Throwable exc) {
			exc.printStackTrace();
		}
	}

	private void createNewPerformanceClass(String name) {
		try {
			File file = new File(this.play.getDirectory() + File.separatorChar
					+ name + ".java");
			file.createNewFile();
			IO.copyResTextFile("Performance.txt", file.getAbsolutePath(), name);
			this.play.insertPerformanceClass(name);
		} catch (Throwable exc) {
			exc.printStackTrace();
		}
	}

	private void createNewOtherClass(String name) {
		try {
			File file = new File(this.play.getDirectory() + File.separatorChar
					+ name + ".java");
			file.createNewFile();
			IO.copyResTextFile("Other.txt", file.getAbsolutePath(), name);
			this.play.insertOtherClass(name);
		} catch (Throwable exc) {
			exc.printStackTrace();
		}
	}

}
