package view;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import listener.MethodInvocation;
import listener.MethodWithParamInvocation;
import listener.RemoveComponentListener;
import model.Play;
import theater.Component;
import theater.Description;
import theater.Invisible;
import theater.Prop;
import theater_intern.IComponent;
import util.ResourceManager;
import util.Utils;

/**
 * Popup-Menu fr Componenten
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class ComponentPopupMenu extends JPopupMenu {

	public ComponentPopupMenu(IComponent icomp) {
		MethodComparator comparator = new MethodComparator();

		Component comp = IComponent.getComp(icomp);
		if (!Play.getPlay().isSimulator()
				|| !Utils.dynInstanceof(comp, Prop.class)) {
			Class<?> cls = comp.getClass();
			do {
				cls = cls.getSuperclass();
				Method[] methods = ComponentPopupMenu.getMethods(comp, cls);
				Arrays.sort(methods, comparator);
				JMenu menu = new JMenu(cls.getName());
				for (Method method : methods) {
					Invisible inv = method.getAnnotation(Invisible.class);
					if (inv == null) {
						JMenuItem m = new JMenuItem(ComponentPopupMenu
								.genShortMethodName(method));
						Description desc = method
								.getAnnotation(Description.class);
						if (desc != null) {
							m.setToolTipText(desc.value());
						}
						if (method.getParameterTypes().length == 0) {
							m.addActionListener(new MethodInvocation(method,
									comp));
						} else {
							m.addActionListener(new MethodWithParamInvocation(
									method, comp));
						}
						menu.add(m);
					}
				}
				if (methods.length == 0) {
					JMenuItem m = new JMenuItem(ResourceManager
							.getResourceManager().getValue("nomethod"));
					m.setEnabled(false);
					menu.add(m);
				}
				this.add(menu);
				if (Play.getPlay().isSimulator()) {
					break;
				}
			} while (cls != Object.class);
		}

		Method[] methods = ComponentPopupMenu.getMethods(comp, comp.getClass());
		Arrays.sort(methods, comparator);
		for (Method method : methods) {
			Invisible inv = method.getAnnotation(Invisible.class);
			if (inv == null) {
				JMenuItem m = new JMenuItem(ComponentPopupMenu
						.genShortMethodName(method));
				Description desc = method.getAnnotation(Description.class);
				if (desc != null) {
					m.setToolTipText(desc.value());
				}
				if (method.getParameterTypes().length == 0) {
					m.addActionListener(new MethodInvocation(method, comp));
				} else {
					m.addActionListener(new MethodWithParamInvocation(method,
							comp));
				}
				this.add(m);
			}
		}
		this.addSeparator();
		JMenuItem rem = new JMenuItem(ResourceManager.getResourceManager()
				.getValue("actor.remove"));
		if (!Utils.dynInstanceof(comp, theater.Actor.class)) {
			rem.addActionListener(new RemoveComponentListener(icomp));
		} else {
			rem.setEnabled(false);
		}
		this.add(rem);
	}

	public static Method[] getMethods(Component c, Class<?> cls) {
		ArrayList<Method> res = new ArrayList<Method>();
		for (Method method : cls.getDeclaredMethods()) {
			if (/*
				 * Modifier.isPublic(method.getModifiers()) &&
				 */!Modifier.isAbstract(method.getModifiers())
			// && !Modifier.isStatic(method.getModifiers())
			/* && method.getDeclaringClass() == cls */) {
				res.add(method);
			}
		}
		return res.toArray(new Method[0]);
	}

	public static String genMethodName(Method method) {
		String str = new String();

		str += buildTypeName(method.getReturnType());
		str += " " + method.getName() + "(";

		Class<?>[] parameterTypes = method.getParameterTypes();
		for (int k = 0; k < parameterTypes.length; k++) {
			str += buildTypeName(parameterTypes[k]);
			if (k < parameterTypes.length - 1) {
				str += ", ";
			}
		}
		str += ")";
		return str;
	}

	public static String genShortMethodName(Method method) {
		String str = new String();

		str += buildTypeName(method.getReturnType());

		String name = method.getName();
		if (name.length() > 20) {
			name = name.substring(0, 17) + "...";
		}
		str += " " + name + "(";

		Class<?>[] parameterTypes = method.getParameterTypes();
		for (int k = 0; k < parameterTypes.length; k++) {
			str += buildTypeName(parameterTypes[k]);
			if (k < parameterTypes.length - 1) {
				str += ", ";
			}
		}
		str += ")";
		return str;
	}

	public static String buildTypeName(Class<?> type) {

		if (!type.isArray()) {
			return type.getName();
		}

		String name = "";
		try {

			// count dimension
			int dim = 0;
			String typeName = type.getName();
			while (typeName.charAt(dim) == '[') {
				dim++;
			}
			
			// build name
			switch (typeName.charAt(dim)) {
			case 'B':
				name = "byte";
				break;
			case 'C':
				name = "char";
				break;
			case 'D':
				name = "double";
				break;
			case 'F':
				name = "float";
				break;
			case 'I':
				name = "int";
				break;
			case 'J':
				name = "long";
				break;
			case 'S':
				name = "short";
				break;
			case 'Z':
				name = "boolean";
				break;
			default:
				name = typeName.substring(dim + 1, typeName.length() - 1);
				break;
			}
			while (dim > 0) {
				name += "[]";
				dim--;
			}

		} catch (Throwable th) {
			return type.getName();
		}
		return name;
	}
}
