package util;

import model.ClassManager;

/**
 * Allgemeine Hilfsroutinen
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class Utils {

	/**
	 * berprft, ob ein Objekt Instanz einer bestimmten Klasse (oder eine derer
	 * Oberklassen) ist. Bei dynamisch geladenen Klassen kann der
	 * instanceof-Operator nicht verwendet werden.
	 * 
	 * @param o
	 * @param c
	 * @return
	 */
	public static boolean dynInstanceof(Object o, Class<?> c) {
		return c.isAssignableFrom(o.getClass());
		//return c.isInstance(o);
	}

	/**
	 * berprft, ob eine Klasse direkt oder indirekt von einer bestimmten
	 * Klasse abgeleitet ist.
	 * 
	 * @param clasz
	 * @param superClasz
	 * @return
	 */
	public static boolean isDerivedClass(Class<?> clasz, Class<?> superClasz) {
		while (clasz != Object.class) {
			if (clasz == superClasz) {
				return true;
			}
			clasz = clasz.getSuperclass();
		}
		return clasz == superClasz;
	}

	/**
	 * Wird aufgerufen, wenn ein schwerer interner Fehler aufgetreten ist
	 * 
	 * @param t
	 */
	public static void handleInternalError(Throwable t) {
		System.err.println("Sorry, an internal error occurred!");
		t.printStackTrace();
		// System.exit(1);
	}

	/**
	 * Liefert die Version vonm Programming-Theater
	 * 
	 * @return
	 */
	public static String getVersion() {
		return "Version 1.0";
	}

	public static boolean checkJavaName(String name) {
		if (name.equals("")) {
			return false;
		}
		name = name.toLowerCase();
		if ((name.charAt(0) < 'a' || name.charAt(0) > 'z')
				&& !(name.charAt(0) == '_' || name.charAt(0) == '$')) {
			return false;
		}
		for (int i = 1; i < name.length(); i++) {
			if (!((name.charAt(i) >= 'a' && name.charAt(i) <= 'z')
					|| (name.charAt(i) >= '0' && name.charAt(i) <= '9')
					|| (name.charAt(i) == '_') || (name.charAt(i) == '$'))) {
				return false;
			}
		}
		return true;
	}

	public static boolean checkClassName(String name) {
		if (!checkJavaName(name)) {
			return false;
		}
		if (ClassManager.getClassManager().classExists(name)) {
			return false;
		}
		return true;
	}

}
