package theater;

/**
 * PixelArea ist ein Interface, das die Grundlage der
 * Kollisionserkennungsmethoden darstellt. Eine PixelArea kann man sich dabei
 * als ein beliebiges Gebiet auf der Bhne vorstellen. Neben einigen zur
 * Verfgung gestellten Standardklassen (Point, Rectangle, Cell, CellArea)
 * implementieren auch die Klassen Stage und Component das Interface. Dadurch
 * sind nur sehr wenige Methoden zur Kollisionserkennung notwendig, die jedoch
 * sehr flexibel und umfassend eingesetzt werden knnen.
 * 
 * @author Dietrich Boles, Universitt Oldenburg, Germany
 * @version 1.0 (17.07.2009)
 * 
 */
public interface PixelArea {

	/**
	 * berprft, ob der Punkt mit den Koordinaten x und y innerhalb der
	 * PixelArea liegt.
	 * 
	 * @param x
	 *            x-Koordinate des Punktes
	 * @param y
	 *            y-Koordinate des Punktes
	 * @return genau dann true, wenn der Punkt mit den Koordinaten x und y
	 *         innerhalb der PixelArea liegt
	 */
	public boolean contains(int x, int y);

	/**
	 * berprft, ob die aufgerufene PixelArea komplett innerhalb der als
	 * Parameter bergebenen PixelArea liegt.
	 * 
	 * @param area
	 *            die zu vergleichende PixelArea
	 * @return genau dann true, wenn die aufgerufene PixelArea komplett
	 *         innerhalb der als Parameter bergebenen PixelArea liegt
	 */
	public boolean isInside(PixelArea area);

	/**
	 * berprft, ob die aufgerufene PixelArea die als Parameter bergebene
	 * PixelArea schneidet.
	 * 
	 * @param area
	 *            die zu vergleichende PixelArea
	 * @return genau dann true, wenn die aufgerufene PixelArea die als Parameter
	 *         bergebene PixelArea schneidet
	 */
	public boolean intersects(PixelArea area);
}
