package compiler.precompiler;

import java.util.ArrayList;

public class MyToken extends Token {

	public boolean isTrace;
	public int openBracket;
	public int closeBracket;
	public int elseOpenBracket;
	public int elseCloseBracket;
	public boolean enddo;
	public boolean leftParenthesis;
	public boolean rightParenthesis;
	public boolean forupdate;
	public boolean makePublic;

	public String classname;
	public String extendsname;

	public ArrayList<ArrayList<VariableInfo>> blocks;

	/**
	 * Constructs a new token for the specified Image and Kind.
	 */
	public MyToken(int kind, String image) {
		this.kind = kind;
		this.image = image;
		this.isTrace = false;
		this.openBracket = 0;
		this.closeBracket = 0;
		this.elseOpenBracket = 0;
		this.elseCloseBracket = 0;
		this.enddo = false;
		this.leftParenthesis = false;
		this.rightParenthesis = false;
		this.forupdate = false;
		this.makePublic = false;
		this.blocks = null;
		this.classname = null;
		this.extendsname = null;
	}

	int realKind = JavaParserConstants.GT;

	/**
	 * Returns a new Token object.
	 */

	public static final Token newToken(int ofKind, String tokenImage) {
		return new MyToken(ofKind, tokenImage);
	}
}
