package scratch.elements.booleans;

import java.util.ArrayList;

import scratch.Renderable;
import scratch.ScratchProgram;
import scratch.elements.BooleanMethodObject;
import scratch.elements.voids.ExitProgramException;
import scratch.elements.voids.FunctionResultException;
import util.PropertyManager;



public class NotBooleanObject extends BooleanMethodObject {
	public NotBooleanObject() {
		super("nicht", PropertyManager.getPropertyManager().getNot(), getParameter());
	}
	
	private static ArrayList<Type> getParameter() {
		ArrayList<Type> parameter = new ArrayList<Type>();
		parameter.add(Type.BOOLEAN);
		return parameter;
	}

	@Override
	public Renderable clone() {
		NotBooleanObject temp = new NotBooleanObject();
		return temp;
	}

	@Override
	public Object performImplementation(ScratchProgram program) throws FunctionResultException, ExitProgramException {
		// Boolean auswerten
		boolean bool = true;
		if (childs.get(0) != null)
			bool = (Boolean)childs.get(0).perform(program);
		
		// Gesamte Auswertung
		return (!bool);
	}
}
