package scratch;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;

import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;

public class ScratchFile {

	public static final String SCRATCH_FILENAME = "ScratchSolist.xml";

	public static void saveProgram(ScratchProgram program, String fileName) {
		FileWriter fw = null;
		try {
			String xmlString = toXML(program);
			File file = new File(fileName);
			fw = new FileWriter(file);
			// fw = new OutputStreamWriter(new FileOutputStream(file), "UTF-8");
			fw.write(xmlString);
			fw.flush();
		} catch (Exception exc) {
		} finally {
			if (fw != null) {
				try {
					fw.close();
				} catch (IOException e) {
				}
			}
		}
	}

	public static void saveProgram(ScratchProgram program, File file)
			throws Exception {
		FileWriter fw = null;
		try {
			String xmlString = toXML(program);
			fw = new FileWriter(file);
			// fw = new OutputStreamWriter(new FileOutputStream(file), "UTF-8");
			fw.write(xmlString);
			fw.flush();
		} finally {
			if (fw != null) {
				try {
					fw.close();
				} catch (IOException e) {
				}
			}
		}
	}

	/**
	 * Liest eine XML-Datei ein und liefert das darin reprsentierte
	 * Scratch-Programm
	 * 
	 * @param xmlFile
	 * @return
	 */
	public static ScratchProgram loadProgram(File xmlFile) throws Exception {
		ScratchProgram program = new ScratchProgram();
		program.loadProgram(xmlFile);
		return program;
	}

	public static ScratchProgram newProgram() {
		ScratchProgram program = new ScratchProgram();
		return program;
	}

	/**
	 * Generiert zu einem Scratch-Programm eine XML-Reprsentation und liefert
	 * diese als String
	 * 
	 * @param program
	 * @return
	 */
	private static String toXML(ScratchProgram program) {
		XMLStreamWriter writer = null;
		StringWriter strWriter = new StringWriter();

		try {
			XMLOutputFactory factory = XMLOutputFactory.newInstance();
			writer = factory.createXMLStreamWriter(strWriter);
			writer.writeStartDocument("ISO-8859-1", "1.0");
			writer.writeStartElement("SCRATCHPROGRAM");

			StorageController controller = program.getProgram();
			if (controller != null)
				program.getProgram().toXML(writer);

			writer.writeEndElement();
			writer.writeEndDocument();
		} catch (Throwable exc) {
			exc.printStackTrace();
		} finally {
			try {
				if (writer != null) {
					writer.close();
				}
			} catch (Throwable exc) {
				exc.printStackTrace();
			}
		}
		return strWriter.toString();
	}
}
