package debugger;

import java.util.ArrayList;
import java.util.List;

import javax.swing.table.AbstractTableModel;

public class StackFrameTableModel extends AbstractTableModel {

	List<FrameElement> stackFrames;

	public StackFrameTableModel() {
		stackFrames = new ArrayList<FrameElement>();
	}

	public void setStackFrames(List<FrameElement> stackFrames) {
		this.stackFrames.clear();
		if (stackFrames != null) {
			this.stackFrames.addAll(stackFrames);
		}
		fireTableDataChanged();
	}

	public int getColumnCount() {
		return 3;
	}

	public int getRowCount() {
		return stackFrames.size();
	}

	public Class<?> getColumnClass(int columnIndex) {
		if (columnIndex == 2) {
			return Integer.class;
		} else {
			return super.getColumnClass(columnIndex);
		}
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		if (stackFrames.size() == 0) {
			return null;
		}
		FrameElement frame = stackFrames.get(rowIndex);
		switch (columnIndex) {
		case 0:
			return frame.getClassName();
		case 1:
			return frame.getMethodName();
		case 2:
			return frame.getLine();
		}
		return null;
	}

	public FrameElement getFrameElement(int i) {
		return stackFrames.get(i);
	}
}