import theater.*;

import java.awt.Color;
import java.awt.Font;

import javax.swing.JPanel;


/**
 * Die Klasse stellt eine Repraesentation einer textuellen Information dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (01.10.2009)
 *
 */
public class Info extends Prop {
    private String info;

    Info(String info) {
        this.info = info;
        makeImage();
    }

    void makeImage() {
        int WIDTH = 220;
        int HEIGHT = 120;
        TheaterImage image = new TheaterImage(WIDTH, HEIGHT);

        // image.setColor(new Color(0, 0, 0, 100));
        // image.fillRect(0, 0, WIDTH, HEIGHT);
        // image.setColor(new Color(255, 255, 255, 160));
        // image.fillRect(5, 5, WIDTH - 10, HEIGHT - 10);
        image.setColor(Color.DARK_GRAY);

        Font font = new Font("Monospaced", Font.BOLD, 12);
        image.setFont(font);
        image.drawString(info,
            (image.getWidth() / 2) - (Metrics.stringWidth(info, font) / 2),
            HEIGHT / 2);
        setImage(image);
    }
}


class Metrics {
    static JPanel p = new JPanel();

    static int stringWidth(String str, Font font) {
        return p.getFontMetrics(font).stringWidth(str);
    }
}
