import theater.*;

import java.awt.Color;
import java.awt.Font;

import javax.swing.JPanel;


/**
 * Die Klasse stellt eine Repraesentation eines Zeichens dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (23.10.2009)
 *
 */
public class Zeichen extends Prop {
    private boolean added;
    private TheaterImage image;
    private String zeichen;

    Zeichen() {
        this(null);
    }

    Zeichen(char zeichen) {
        this("" + zeichen);
    }

    private Zeichen(String zeichen) {
        this.zeichen = zeichen;
        image = new TheaterImage(Terminal.CELLSIZE, Terminal.CELLSIZE);
        image.setFont(new Font("Monospaced", Font.PLAIN, Terminal.FONT_SIZE));
        setImage(image);
        setChar();
        added = false;
    }

    @Invisible
    @Override
    public void addedToStage(Stage stage) {
        added = true;
    }

    @Invisible
    @Override
    public void setLocation(int col, int row) {
        if (!added) {
            super.setLocation(col, row);
        }
    }

    @Invisible
    void setChar() {
        image.setColor(Terminal.BG_COLOR);
        image.fill();

        if (zeichen != null) {
            image.setColor(Terminal.FG_COLOR);
            image.drawString(zeichen,
                (image.getWidth() / 2) -
                (Metrics.stringWidth(zeichen, image.getFont()) / 2),
                (image.getHeight() / 2) +
                (Metrics.stringHeight(image.getFont()) / 5));
        }
    }

    @Invisible
    void set(char zeichen) {
        this.zeichen = "" + zeichen;
        setChar();
    }

    @Invisible
    void clear() {
        this.zeichen = null;
        setChar();
    }

    @Invisible
    void redraw() {
        setChar();
    }
}


class Metrics {
    static JPanel p = new JPanel();

    static int stringWidth(String str, Font font) {
        return p.getFontMetrics(font).stringWidth(str);
    }

    static int stringHeight(Font font) {
        return p.getFontMetrics(font).getHeight();
    }
}
