import theater.*;

import javax.swing.JOptionPane;


/**
 * ActionHandler zum Ermitteln der Anzahl an mglichen Lsungen des aktuellen Feldes
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (01.10.2009)
 *
 */
public class Auskunft extends ActionHandler {
    public void handleAction(Stage stage, Actor solist) {
        Feld feld = ((Spielfeld) stage).getFeld();
        String msg = null;
        int anzahl = feld.getAnzahlLoesungen();

        if (anzahl == Feld.DEF_LOESUNGEN) {
            msg = "Es existieren mehr als " + Feld.MAX_LOESUNGEN +
                " Lsungen.";
        } else if (anzahl == 1) {
            msg = "Bei der aktuellen Spielfeldbelegung existiert 1 Lsung.";
        } else {
            msg = "Bei der aktuellen Spielfeldbelegung existieren " + anzahl +
                " Lsungen.";
        }

        JOptionPane.showMessageDialog(null, msg, "Anzahl Lsungen",
            JOptionPane.INFORMATION_MESSAGE);
    }
}
