import theater.*;

import java.util.List;


/**
 * Die Klasse stellt eine Repraesentation des Marienkfers dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (04.11.2009)
 */
public class Marienkaefer extends Actor {
    protected Solist kara; // Name des Solisten

    // Default-Konstruktor (muss implementiert werden!)
    public Marienkaefer() {
        super(); // nicht loeschen!
        setImage("marienkaefer.gif");
        setZCoordinate(4);

        kara = (Solist) this; // Solist bekommt den Namen kara

        // weitere Initialisierungen
    }

    // Copy-Konstruktor (muss implementiert werden!)
    public Marienkaefer(Marienkaefer actor) {
        super(actor); // nicht loeschen!

        kara = (Solist) this; // Solist bekommt den Namen kara

        // weitere Initialisierungen
    }

    @Invisible
    public void main() {
        myProgram();
    }

    @Invisible
    public void myProgram() {
    }

    @Description("Mache einen Schritt vorwrts!")
    public void move() {
        Performance.getPerformance().lock();

        try {
            if (treeFront()) {
                throw new TreeFrontException();
            }

            // freeze ist notwendig, weil insbesondere in der Methode adaptView sehr viele
            // Methoden aufgerufen werden, die Sichtbarkeitsaspekte betreffen. Ohne
            // freeze wird eine Auffhrung sehr langsam.
            Performance.getPerformance().freeze();

            try {
                int col = getColumn();
                int row = getRow();
                int rotation = getRotation();
                Landschaft landschaft = (Landschaft) getStage();
                Component mushroom = null;

                switch (rotation) {
                case 0:

                    if ((mushroom = mushroomOnTile(landschaft.calcColumn(col +
                                        1), row)) != null) {
                        if (!mushroomMovePossible(landschaft.calcColumn(col +
                                        2), row)) {
                            throw new MushroomMoveException();
                        }

                        mushroom.setLocation(landschaft.calcColumn(col + 2), row);
                    }

                    setLocation(col + 1, row);

                    break;

                case 90:

                    if ((mushroom = mushroomOnTile(col,
                                    landschaft.calcRow(row + 1))) != null) {
                        if (!mushroomMovePossible(col,
                                    landschaft.calcRow(row + 2))) {
                            throw new MushroomMoveException();
                        }

                        mushroom.setLocation(col, landschaft.calcRow(row + 2));
                    }

                    setLocation(col, row + 1);

                    break;

                case 180:

                    if ((mushroom = mushroomOnTile(landschaft.calcColumn(col -
                                        1), row)) != null) {
                        if (!mushroomMovePossible(landschaft.calcColumn(col -
                                        2), row)) {
                            throw new MushroomMoveException();
                        }

                        mushroom.setLocation(landschaft.calcColumn(col - 2), row);
                    }

                    setLocation(col - 1, row);

                    break;

                case 270:

                    if ((mushroom = mushroomOnTile(col,
                                    landschaft.calcRow(row - 1))) != null) {
                        if (!mushroomMovePossible(col,
                                    landschaft.calcRow(row - 2))) {
                            throw new MushroomMoveException();
                        }

                        mushroom.setLocation(col, landschaft.calcRow(row - 2));
                    }

                    setLocation(col, row - 1);

                    break;
                }

                ((Landschaft) getStage()).adaptView();
            } finally {
                Performance.getPerformance().unfreeze();
            }
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Description("Drehe um 90 nach links!")
    public void turnLeft() {
        Performance.getPerformance().lock();
        Performance.getPerformance().freeze();

        try {
            int rotation = getRotation();
            rotation = ((rotation + 360) - 90) % 360;
            setRotation(rotation);
            ((Landschaft) getStage()).adaptView();
        } finally {
            Performance.getPerformance().unfreeze();
            Performance.getPerformance().unlock();
        }
    }

    @Description("Drehe um 90 nach rechts!")
    public void turnRight() {
        Performance.getPerformance().lock();
        Performance.getPerformance().freeze();

        try {
            int rotation = getRotation();
            rotation = (rotation + 90) % 360;
            setRotation(rotation);
            ((Landschaft) getStage()).adaptView();
        } finally {
            Performance.getPerformance().unfreeze();
            Performance.getPerformance().unlock();
        }
    }

    @Description("Lege ein Kleeblatt hin!")
    public void putLeaf() {
        Performance.getPerformance().lock();
        Performance.getPerformance().freeze();

        try {
            int col = getColumn();
            int row = getRow();

            if (getStage().getComponentsAt(col, row, Kleeblatt.class).size() > 0) {
                throw new LeafExistsException();
            }

            Kleeblatt leaf = new Kleeblatt();
            getStage().add(leaf, col, row);
            ((Landschaft) getStage()).adaptView();
        } finally {
            Performance.getPerformance().unfreeze();
            Performance.getPerformance().unlock();
        }
    }

    @Description("Nimm ein Kleeblatt auf!")
    public void removeLeaf() {
        Performance.getPerformance().lock();
        Performance.getPerformance().freeze();

        try {
            List<Component> leafs = getStage()
                                        .getComponentsAt(getColumn(), getRow(),
                    Kleeblatt.class);

            if (leafs.size() > 0) {
                getStage().remove(leafs.get(0));
            } else {
                throw new LeafNotExistsException();
            }
        } finally {
            Performance.getPerformance().unfreeze();
            Performance.getPerformance().unlock();
        }
    }

    @Description("Stehe ich vor einem Baumstumpf?")
    public boolean treeFront() {
        Performance.getPerformance().lock();

        try {
            int rotation = getRotation();
            Landschaft landschaft = (Landschaft) getStage();

            List<Component> trees = null;

            switch (rotation) {
            case 0:
                trees = getStage()
                            .getComponentsAt(landschaft.calcColumn(getColumn() +
                            1), getRow(), Baumstumpf.class);

                break;

            case 90:
                trees = getStage()
                            .getComponentsAt(getColumn(),
                        landschaft.calcRow(getRow() + 1), Baumstumpf.class);

                break;

            case 180:
                trees = getStage()
                            .getComponentsAt(landschaft.calcColumn(getColumn() -
                            1), getRow(), Baumstumpf.class);

                break;

            case 270:
                trees = getStage()
                            .getComponentsAt(getColumn(),
                        landschaft.calcRow(getRow() - 1), Baumstumpf.class);

                break;
            }

            return trees.size() > 0;
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Description("Ist links von mir ein Baumstumpf?")
    public boolean treeLeft() {
        Performance.getPerformance().lock();

        try {
            int rotation = getRotation();
            Landschaft landschaft = (Landschaft) getStage();

            List<Component> trees = null;

            switch (rotation) {
            case 0:
                trees = getStage()
                            .getComponentsAt(getColumn(),
                        landschaft.calcRow(getRow() - 1), Baumstumpf.class);

                break;

            case 90:
                trees = getStage()
                            .getComponentsAt(landschaft.calcColumn(getColumn() +
                            1), getRow(), Baumstumpf.class);

                break;

            case 180:
                trees = getStage()
                            .getComponentsAt(getColumn(),
                        landschaft.calcRow(getRow() + 1), Baumstumpf.class);

                break;

            case 270:
                trees = getStage()
                            .getComponentsAt(landschaft.calcColumn(getColumn() -
                            1), getRow(), Baumstumpf.class);

                break;
            }

            return trees.size() > 0;
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Description("Ist rechts von mir ein Baumstumpf?")
    public boolean treeRight() {
        Performance.getPerformance().lock();

        try {
            int rotation = getRotation();
            Landschaft landschaft = (Landschaft) getStage();

            List<Component> trees = null;

            switch (rotation) {
            case 0:
                trees = getStage()
                            .getComponentsAt(getColumn(),
                        landschaft.calcRow(getRow() + 1), Baumstumpf.class);

                break;

            case 90:
                trees = getStage()
                            .getComponentsAt(landschaft.calcColumn(getColumn() -
                            1), getRow(), Baumstumpf.class);

                break;

            case 180:
                trees = getStage()
                            .getComponentsAt(getColumn(),
                        landschaft.calcRow(getRow() - 1), Baumstumpf.class);

                break;

            case 270:
                trees = getStage()
                            .getComponentsAt(landschaft.calcColumn(getColumn() +
                            1), getRow(), Baumstumpf.class);

                break;
            }

            return trees.size() > 0;
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Description("Stehe ich vor einem Pilz?")
    public boolean mushroomFront() {
        Performance.getPerformance().lock();

        try {
            int rotation = getRotation();
            Landschaft landschaft = (Landschaft) getStage();

            List<Component> mushrooms = null;

            switch (rotation) {
            case 0:
                mushrooms = getStage()
                                .getComponentsAt(landschaft.calcColumn(getColumn() +
                            1), getRow(), Pilz.class);

                break;

            case 90:
                mushrooms = getStage()
                                .getComponentsAt(getColumn(),
                        landschaft.calcRow(getRow() + 1), Pilz.class);

                break;

            case 180:
                mushrooms = getStage()
                                .getComponentsAt(landschaft.calcColumn(getColumn() -
                            1), getRow(), Pilz.class);

                break;

            case 270:
                mushrooms = getStage()
                                .getComponentsAt(getColumn(),
                        landschaft.calcRow(getRow() - 1), Pilz.class);

                break;
            }

            return mushrooms.size() > 0;
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Description("Stehe ich auf einem Kleeblatt?")
    public boolean onLeaf() {
        Performance.getPerformance().lock();

        try {
            return getStage()
                       .getComponentsAt(getColumn(), getRow(), Kleeblatt.class)
                       .size() > 0;
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Invisible
    public void setLocation(int col, int row) {
        if ((this.getColumn() == col) && (this.getRow() == row)) {
            return;
        }

        Landschaft landschaft = (Landschaft) getStage();

        col = landschaft.calcColumn(col);

        row = landschaft.calcRow(row);

        if ((this.getColumn() == col) && (this.getRow() == row)) {
            return;
        }

        // no Baumstumpf or Pilz allowed
        if (getStage().getComponentsAt(col, row, Baumstumpf.class, Pilz.class)
                    .size() > 0) {
            return;
        }

        super.setLocation(col, row);
        ((Landschaft) getStage()).adaptView();
    }

    @Invisible
    private boolean mushroomMovePossible(int toCol, int toRow) {
        List<Component> frontFrontComps = getStage()
                                              .getComponentsAt(toCol, toRow,
                Pilz.class, Baumstumpf.class, Marienkaefer.class);

        if (frontFrontComps.size() > 0) {
            return false; // Pilz or Baumstumpf or Marienkaefer
        } else {
            return true;
        }
    }

    @Invisible
    private Component mushroomOnTile(int col, int row) {
        List<Component> mushrooms = getStage()
                                        .getComponentsAt(col, row, Pilz.class);

        if (mushrooms.size() > 0) {
            return mushrooms.get(0);
        } else {
            return null;
        }
    }
}
