import theater.*;

import java.util.ArrayList;
import java.util.List;


/**
 * Repraesentation eines Stabes
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (30.09.2009)
 *
 */
public class Stab extends Prop {
    private boolean added;
    private int nummer;
    private ArrayList<Scheibe> scheiben;

    public Stab(int nummer) {
        setImage("stab.gif");
        this.added = false;
        this.nummer = nummer;
        this.scheiben = new ArrayList<Scheibe>();
    }

    @Invisible
    public void addedToStage(Stage stage) {
        this.added = true;
    }

    @Invisible
    boolean istLeer() {
        return this.scheiben.size() == 0;
    }

    @Invisible
    int liefereAnzahlScheiben() {
        return this.scheiben.size();
    }

    @Invisible
    Scheibe liefereObersteScheibe() {
        return scheiben.get(0);
    }

    @Invisible
    Scheibe entferneObersteScheibe() {
        return scheiben.remove(0);
    }

    @Invisible
    void legeNeueScheibe(Scheibe scheibe) {
        scheiben.add(0, scheibe);
    }

    @Invisible
    List<Scheibe> liefereScheiben() {
        return scheiben;
    }

    @Invisible
    void leeren() {
        this.scheiben = new ArrayList<Scheibe>();
    }

    @Invisible
    public void setLocation(int col, int row) {
        if (!added) {
            super.setLocation(col, row);
        }
    }
}
