import theater.*;


/**
 * Die Klasse stellt eine Repraesentation der Geister dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (29.09.2009)
 *
 */
public class Geist extends Prop {
    public Geist() {
        setZCoordinate(2);
        setImage(new TheaterIcon("geist-anim.gif"));

        setVisible(false);
    }

    @Invisible // soll nicht im Popup-Men erscheinen

    public void vertreiben() {
        Performance.getPerformance().lock();

        try {
            // der Geist erscheint, wird dann langsam unsichtbar
            // und letztendlich ganz von der Bhne entfernt
            Performance.getPerformance().playSound("wind.wav");
            setVisible(true);

            TheaterImage image = getImage();
            int transp = image.getTransparency();

            int step = 10;
            while (transp > step) {
                transp = transp - step;
                image.setTransparency(transp);
            }

            getStage().remove(this);
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Invisible // soll nicht im Popup-Men erscheinen

    public void setLocation(int col, int row) {
        Performance.getPerformance().lock();

        try {
            if ((this.getColumn() == col) && (this.getRow() == row)) {
                // Geist befindet sich bereits auf dieser Zelle
                return;
            }

            if ((col < 0) || (row < 0) ||
                    (col >= this.getStage().getNumberOfColumns()) ||
                    (row >= this.getStage().getNumberOfRows())) {
                // nur innerhalb der sichtbaren Bhne 
                return;
            }

            Actor solist = getStage().getSolist();

            if ((col == solist.getColumn()) && (row == solist.getRow())) {
                // Geist kann nicht auf die Zelle umplatziert werden, auf der
                // sich der Solist befindet
                return;
            }

            // Geist auf Kachel?
            if (this.getStage().getComponentsAt(col, row, Geist.class).size() > 0) {
                // ein Geist kann nicht auf eine Kachel platziert werden, auf der sich
                // bereits ein Geist befindet
                return;
            }

            // ruft die geerbte Methode auf, die die tatschliche Umplatzierung
            // vornimmt
            super.setLocation(col, row);
        } finally {
            Performance.getPerformance().unlock();
        }
    }
}
