import theater.*;


/**
 * Die Klasse stellt eine Repraesentation der Damen dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (07.10.2009)
 *
 */
public class Dame extends Prop {
    boolean added = false; // Flag, ob auf Spielfeld

    public Dame() {
        setImage("dame.gif");
        setZCoordinate(1); // vorne
    }

    @Invisible
    @Override
    public void addedToStage(Stage stage) {
        added = true;
    }

    @Invisible
    @Override
    public void removedFromStage(Stage stage) {
        added = false;
    }

    @Invisible
    @Override
    public void setLocation(int col, int row) {
        Performance.getPerformance().lock();

        try {
            if ((col == getColumn()) && (row == getRow())) {
                return;
            }

            Spielfeld feld = (Spielfeld) getStage();

            if ((col < 0) || (row < 0) || (col >= feld.getSize()) ||
                    (row >= feld.getSize())) {
                return;
            }

            if (added) { // bereits auf dem Feld

                // whrend eine Simulation luft, darf nicht verschoben werden
                MyPerformance perf = (MyPerformance) Performance.getPerformance();

                if (perf.isRunning()) {
                    return;
                }

                feld.removeDame(getRow(), getColumn());

                if (feld.checkSetDame(row, col)) {
                    // Zug mglich
                    feld.setDame(row, col);
                    super.setLocation(col, row);
                } else {
                    // Zug nicht mglich, zurcksetzen
                    feld.setDame(getRow(), getColumn());
                }
            } else { // neu

                if (feld.checkSetDame(row, col)) {
                    // Zug mglich
                    feld.setDame(row, col);
                    super.setLocation(col, row);
                } else {
                    // Platzieren der Dame hier nicht mglich
                    feld.remove(this);
                }
            }
        } finally {
            Performance.getPerformance().unlock();
        }
    }
}
