import theater.*;

import java.awt.Color;
import java.awt.event.*;


/**
 * Die Klasse stellt eine Repraesentation des Terminals dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (23.10.2009)
 *
 */
public class Terminal extends Stage {
    static int ROWS = 30;
    static int COLS = 40;
    static int CELLSIZE = 12;
    static Color BG_COLOR = Color.BLACK;
    static Color FG_COLOR = Color.GREEN;
    static int FONT_SIZE = CELLSIZE;
    TheaterImage image;

    public Terminal() {
        super(COLS, ROWS, CELLSIZE);
        image = new TheaterImage(COLS * CELLSIZE, ROWS * CELLSIZE);
        image.setColor(BG_COLOR);
        image.fill();
        setBackground(image);

        setSolist(Actor.createSolist(), 0, 0);
    }

    void resize(int cols, int rows, int cellsize) {
        if (cols < 1) {
            cols = 1;
        } else if (cols > 100) {
            cols = 100;
        }

        if (rows < 1) {
            rows = 1;
        } else if (rows > 100) {
            rows = 100;
        }

        if (cellsize < 1) {
            cellsize = 1;
        } else if (cellsize > 100) {
            cellsize = 100;
        }

        Performance.getPerformance().freeze();

        COLS = cols;
        ROWS = rows;
        CELLSIZE = cellsize;
        FONT_SIZE = cellsize;
        setSize(cols, rows, cellsize);

        ((Schreiber) getSolist()).clear();
        ((Schreiber) getSolist()).move(0, 0);
        ((Schreiber) getSolist()).updateImage();

        Performance.getPerformance().unfreeze();
    }

    void changeBackgroundColor(Color color) {
        Performance.getPerformance().freeze();
        BG_COLOR = color;

        image.setColor(BG_COLOR);
        image.fill();
        setBackground(image);

        ((Schreiber) getSolist()).updateImage();

        for (Component zeichen : getComponents(Zeichen.class)) {
            ((Zeichen) zeichen).redraw();
        }

        Performance.getPerformance().unfreeze();
    }

    Color getBackgroundColor() {
        return BG_COLOR;
    }

    void changeForegroundColor(Color color) {
        Performance.getPerformance().freeze();
        FG_COLOR = color;

        ((Schreiber) getSolist()).updateImage();

        for (Component zeichen : getComponents(Zeichen.class)) {
            ((Zeichen) zeichen).redraw();
        }

        Performance.getPerformance().unfreeze();
    }

    Color getForegroundColor() {
        return FG_COLOR;
    }

    public void keyPressed(KeyInfo info) {
        Performance.getPerformance().lock();

        try {
            char ch = info.getKeyChar();
            int code = info.getKeyCode();

            if (ch != KeyEvent.CHAR_UNDEFINED) {
                if (code == KeyEvent.VK_ENTER) {
                    Schreiber schreiber = (Schreiber) getSolist();
                    schreiber.endInput();

                    synchronized (schreiber) {
                        schreiber.notify();
                    }
                } else if ((code == KeyEvent.VK_DELETE) ||
                        (code == KeyEvent.VK_BACK_SPACE)) {
                    ((Schreiber) getSolist()).delInput();
                } else {
                    ((Schreiber) getSolist()).newInput(ch);
                }
            }
        } finally {
            Performance.getPerformance().unlock();
        }
    }
}
