import theater.*;


public class Springer extends Actor {
    private boolean active; // interner Flag, ob der Springer gerade agiert
    private boolean added;

    // Default-Konstruktor (muss implementiert werden!)
    public Springer() {
        super(); // nicht loeschen!
        setImage("springer.gif");
        setZCoordinate(2); // vorne
        active = false;
        added = false;
    }

    // Copy-Konstruktor (muss implementiert werden!)
    public Springer(Springer actor) {
        super(actor); // nicht loeschen!
        setImage("springer.gif");
        active = actor.active;
        added = actor.added;
    }

    @Invisible
    @Override
    public void addedToStage(Stage stage) {
        added = true;
    }

    @Description("<html>Liefert die aktuelle Gre des Spielfeldes.</html>")
    public int getSizeOfBoard() {
        Performance.getPerformance().lock();

        try {
            return ((Spielfeld) getStage()).getSize();
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Description("<html>Liefert die Spalte des Feldes, auf dem sich der Springer aktuell befindet.</html>")
    public int getColumn() {
        return super.getColumn();
    }

    @Description("<html>Liefert die Reihe des Feldes, auf dem sich der Springer aktuell befindet.</html>")
    public int getRow() {
        return super.getRow();
    }

    @Description("<html>Verschiebt den Springer auf das angegebene Feld " +
    "(erster Parameter = Reihe, zweiter Parameter = Spalte)." +
    "<br>Fehler, wenn ungltige Koordinaten bergeben oder die Regeln des Springerproblems verletzt werden.</html>")
    public void jump(int row, int col) {
        Performance.getPerformance().lock();

        try {
            Spielfeld feld = (Spielfeld) getStage();

            // ungltige Koordinaten
            if ((row < 0) || (col < 0) || (row >= feld.getSize()) ||
                    (col >= feld.getSize())) {
                throw new RuntimeException("Ungltige Koordinaten: (" + row +
                    "/" + col + ")");
            }

            // gleiches Feld 
            if ((row == getRow()) && (col == getColumn())) {
                throw new RuntimeException(
                    "Springer steht bereits auf diesem Feld: (" + row + "/" +
                    col + ")");
            }

            // ungltiger Zug
            if (!validJump(row, col)) {
                throw new RuntimeException("Ungltiger Springerzug: (" + row +
                    "/" + col + ")");
            }

            // Feld belegt
            if (feld.getComponentsAt(col, row, Belegung.class).size() >= 1) {
                throw new RuntimeException("Feld ist belegt: (" + row + "/" +
                    col + ")");
            }

            int oldRow = getRow();
            int oldCol = getColumn();
            active = true;
            setLocation(col, row);
            active = false;
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Description("<html>berprft, ob der Springer gem den Regeln auf das " +
    "angegebene Feld springen kann " +
    "(erster Parameter = Reihe, zweiter Parameter = Spalte).")
    public boolean canJump(int row, int col) {
        Performance.getPerformance().lock();

        try {
            Spielfeld feld = (Spielfeld) getStage();
            int size = feld.getSize();

            // auerhalb des Feldes
            if ((row < 0) || (col < 0) || (row >= size) || (col >= size)) {
                return false;
            }

            // gleiches Feld
            if ((row == getRow()) && (col == getColumn())) {
                return false;
            }

            // Feld belegt
            if (feld.getComponentsAt(col, row, Belegung.class).size() >= 1) {
                return false;
            }

            return true;
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Description("<html>Markiert das angegebene Feld als belegt " +
    "(erster Parameter = Reihe, zweiter Parameter = Spalte)." +
    "<br>Fehler, wenn ungltige Koordinaten bergeben werden oder das Feld bereits markiert ist.</html>")
    public void mark(int row, int col) {
        Performance.getPerformance().lock();

        try {
            Spielfeld feld = (Spielfeld) getStage();

            // ungltige Koordinaten
            if ((row < 0) || (col < 0) || (row >= feld.getSize()) ||
                    (col >= feld.getSize())) {
                throw new RuntimeException("Ungltige Koordinaten: (" + row +
                    "/" + col + ")");
            }

            // bereits markiert 
            if (isMarked(row, col)) {
                throw new RuntimeException("Feld ist bereits markiert: (" +
                    row + "/" + col + ")");
            }

            Performance.getPerformance().freeze();
            feld.add(new Belegung(), col, row);
            Performance.getPerformance().unfreeze();
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Description("<html>Entfernt die Markierung des Feldes " +
    "(erster Parameter = Reihe, zweiter Parameter = Spalte)." +
    "<br>Fehler, wenn ungltige Koordinaten bergeben werden oder das Feld nicht markiert ist.</html>")
    public void unmark(int row, int col) {
        Performance.getPerformance().lock();

        try {
            Spielfeld feld = (Spielfeld) getStage();

            // ungltige Koordinaten
            if ((row < 0) || (col < 0) || (row >= feld.getSize()) ||
                    (col >= feld.getSize())) {
                throw new RuntimeException("Ungltige Koordinaten: (" + row +
                    "/" + col + ")");
            }

            // bereits markiert 
            if (!isMarked(row, col)) {
                throw new RuntimeException("Feld ist nicht markiert: (" + row +
                    "/" + col + ")");
            }

            feld.remove(feld.getComponentsAt(col, row, Belegung.class));
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Description("<html>berprft, ob das angegebene Feld markiert ist " +
    "(erster Parameter = Reihe, zweiter Parameter = Spalte)." +
    "<br>Fehler, wenn ungltige Koordinaten bergeben werden.</html>")
    public boolean isMarked(int row, int col) {
        Performance.getPerformance().lock();

        try {
            Spielfeld feld = (Spielfeld) getStage();

            // ungltige Koordinaten
            if ((row < 0) || (col < 0) || (row >= feld.getSize()) ||
                    (col >= feld.getSize())) {
                throw new RuntimeException("Ungltige Koordinaten: (" + row +
                    "/" + col + ")");
            }

            return feld.getComponentsAt(col, row, Belegung.class).size() >= 1;
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Invisible
    @Override
    public void setLocation(int col, int row) {
        Performance.getPerformance().lock();

        try {
            if (!added) {
                super.setLocation(col, row);

                return;
            }

            MyPerformance perf = (MyPerformance) Performance.getPerformance();

            // Springer darf bei laufender Simulation nicht vom Nutzer verschoben werden
            if (perf.isRunning() && !active) {
                return;
            }

            Spielfeld feld = (Spielfeld) getStage();
            int size = feld.getSize();

            // gleiches Feld
            if ((col == getColumn()) && (row == getRow())) {
                return;
            }

            // auerhalb des Spielfeldes
            if ((col < 0) || (row < 0) || (col >= size) || (row >= size)) {
                return;
            }

            // Feld belegt
            if (getStage().getComponentsAt(col, row, Belegung.class).size() >= 1) {
                return;
            }

            super.setLocation(col, row);
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Invisible
    boolean isActive() {
        return active;
    }

    @Invisible
    private boolean validJump(int row, int col) {
        int r = getRow();
        int c = getColumn();

        return ((row == (r - 1)) && (col == (c - 2))) ||
        ((row == (r - 2)) && (col == (c - 1))) ||
        ((row == (r - 2)) && (col == (c + 1))) ||
        ((row == (r - 1)) && (col == (c + 2))) ||
        ((row == (r + 1)) && (col == (c + 2))) ||
        ((row == (r + 2)) && (col == (c + 1))) ||
        ((row == (r + 2)) && (col == (c - 1))) ||
        ((row == (r + 1)) && (col == (c - 2)));
    }
}
