import theater.*;

import java.util.List;


/**
 * Die Klasse stellt eine Repraesentation des Marienkfer-Territoriums dar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (04.11.2009)
 */
public class Landschaft extends Stage {
    static final int FULL_TRANSPARENCY = 255;
    static final int LESS_TRANSPARENCY = 125;
    private boolean worldView;

    public Landschaft() {
        super(9, 9, 28);
        setBackground("kachel.gif");
        worldView = false;

        // erzeugt den Solist und platziert in mitten auf der Bhne
        setSolist(Actor.createSolist(), 0, 0);
    }

    void setWorldView(boolean world) {
        Performance.getPerformance().lock();
        Performance.getPerformance().freeze();

        try {
            if (world != worldView) {
                worldView = world;
                adaptView();
            }
        } finally {
            Performance.getPerformance().unfreeze();
            Performance.getPerformance().unlock();
        }
    }

    boolean isWorldView() {
        Performance.getPerformance().lock();

        try {
            return worldView;
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    void adaptView() {
        if (worldView) {
            List<Component> comps = getComponents();

            for (Component comp : comps) {
                comp.getImage().setTransparency(255);
            }
        } else {
            Actor solist = getSolist();
            List<Component> comps = getComponents(Kleeblatt.class);

            for (Component comp : comps) {
                if ((solist.getColumn() == comp.getColumn()) &&
                        (solist.getRow() == comp.getRow())) {
                    comp.getImage().setTransparency(FULL_TRANSPARENCY);
                } else {
                    comp.getImage().setTransparency(LESS_TRANSPARENCY);
                }
            }

            comps = getComponents(Pilz.class);

            for (Component comp : comps) {
                if (inFront(comp, solist)) {
                    comp.getImage().setTransparency(FULL_TRANSPARENCY);
                } else {
                    comp.getImage().setTransparency(LESS_TRANSPARENCY);
                }
            }

            comps = getComponents(Baumstumpf.class);

            for (Component comp : comps) {
                if (inFront(comp, solist) || isLeft(comp, solist) ||
                        isRight(comp, solist)) {
                    comp.getImage().setTransparency(FULL_TRANSPARENCY);
                } else {
                    comp.getImage().setTransparency(LESS_TRANSPARENCY);
                }
            }
        }
    }

    boolean inFront(Component who, Component fromWhom) {
        switch (fromWhom.getRotation()) {
        case 0:
            return (who.getRow() == fromWhom.getRow()) &&
            (who.getColumn() == calcColumn(fromWhom.getColumn() + 1));

        case 90:
            return (who.getColumn() == fromWhom.getColumn()) &&
            (who.getRow() == calcRow(fromWhom.getRow() + 1));

        case 180:
            return (who.getRow() == fromWhom.getRow()) &&
            (who.getColumn() == calcColumn(fromWhom.getColumn() - 1));

        default: // case 270:

            return (who.getColumn() == fromWhom.getColumn()) &&
            (who.getRow() == calcRow(fromWhom.getRow() - 1));
        }
    }

    boolean isLeft(Component who, Component fromWhom) {
        switch (fromWhom.getRotation()) {
        case 0:
            return (who.getColumn() == fromWhom.getColumn()) &&
            (who.getRow() == calcRow(fromWhom.getRow() - 1));

        case 90:
            return (who.getRow() == fromWhom.getRow()) &&
            (who.getColumn() == calcColumn(fromWhom.getColumn() + 1));

        case 180:
            return (who.getColumn() == fromWhom.getColumn()) &&
            (who.getRow() == calcRow(fromWhom.getRow() + 1));

        default: // case 270:

            return (who.getRow() == fromWhom.getRow()) &&
            (who.getColumn() == calcColumn(fromWhom.getColumn() - 1));
        }
    }

    boolean isRight(Component who, Component fromWhom) {
        switch (fromWhom.getRotation()) {
        case 0:
            return (who.getColumn() == fromWhom.getColumn()) &&
            (who.getRow() == calcRow(fromWhom.getRow() + 1));

        case 90:
            return (who.getRow() == fromWhom.getRow()) &&
            (who.getColumn() == calcColumn(fromWhom.getColumn() - 1));

        case 180:
            return (who.getColumn() == fromWhom.getColumn()) &&
            (who.getRow() == calcRow(fromWhom.getRow() - 1));

        default: // case 270:

            return (who.getRow() == fromWhom.getRow()) &&
            (who.getColumn() == calcColumn(fromWhom.getColumn() + 1));
        }
    }

    int calcColumn(int col) {
        col = col % getNumberOfColumns();

        if (col < 0) {
            col = getNumberOfColumns() + col;
        }

        return col;
    }

    int calcRow(int row) {
        row = row % getNumberOfRows();

        if (row < 0) {
            row = getNumberOfRows() + row;
        }

        return row;
    }
}
