import theater.*;

import java.util.List;

/**
 * ActionHandler, um kurzfristig die Geister sichtbar zu machen
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (29.09.2009)
 *
 */
public class GeisterSichtbar extends ActionHandler {
    public void handleAction(Stage stage, Actor solist) {
        Performance.getPerformance().playSound("lachen.wav");

        List<Component> geister = stage.getComponents(Geist.class);

        if (geister.size() == 0) {
            return; // keine Geister
        }

        int transpSpeicher = geister.get(0).getImage().getTransparency();

        // die Geister erscheinen, werden dann langsam unsichtbar
        // und letztendlich ganz von der Bhne entfernt
        Performance.getPerformance().freeze();

        for (Component geist : geister) {
            geist.setVisible(true);
        }

        Performance.getPerformance().unfreeze();

        int transp = transpSpeicher;

        int step = 10;

        while (transp > step) {
            transp = transp - step;
            Performance.getPerformance().freeze();

            for (Component geist : geister) {
                geist.getImage().setTransparency(transp);
            }

            Performance.getPerformance().unfreeze();
        }

        Performance.getPerformance().freeze();

        for (Component geist : geister) {
            geist.setVisible(false);
            geist.getImage().setTransparency(transpSpeicher);
        }

        Performance.getPerformance().unfreeze();
    }
}
