import theater.*;


/**
 * Die Klasse stellt eine Repraesentation des Koordinators dar. Dieser ist unsichtbar.
 *
 * @author Dietrich Boles (Universitaet Oldenburg)
 * @version 1.0 (05.10.2009)
 *
 */
public class Koordinator extends Actor {
    // Default-Konstruktor (muss implementiert werden!)
    public Koordinator() {
        super(); // nicht loeschen!
        setVisible(false); // Koordinator ist unsichtbar
    }

    // Copy-Konstruktor (muss implementiert werden!)
    public Koordinator(Koordinator actor) {
        super(actor); // nicht loeschen!
        setVisible(false);
    }

    @Description("Liefert die Anzahl an Reihen des Spielfelds.")
    public int getNumberOfRows() {
        Performance.getPerformance().lock();

        try {
            return getStage().getNumberOfRows();
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Description("Liefert die Anzahl an Spalten des Spielfelds.")
    public int getNumberOfColumns() {
        Performance.getPerformance().lock();

        try {
            return getStage().getNumberOfColumns();
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Description("<html>Versetzt die angegebene Zelle (erster Parameter = Reihe,<br>" +
    "zweiter Parameter = Spalte) in den Zustand lebendig.</html>")
    public void setLiving(int reihe, int spalte) {
        Performance.getPerformance().lock();
        Performance.getPerformance().freeze();

        try {
            ((Spielfeld) getStage()).checkRow(reihe);
            ((Spielfeld) getStage()).checkCol(spalte);

            if (!isLiving(reihe, spalte)) {
                Zelle cell = new Zelle();
                getStage().add(cell, spalte, reihe);
            }
        } finally {
            Performance.getPerformance().unfreeze();
            Performance.getPerformance().unlock();
        }
    }

    @Description("<html>Versetzt die angegebene Zelle (erster Parameter = Reihe,<br>" +
    "zweiter Parameter = Spalte) in den Zustand tot.</html>")
    public void setDead(int reihe, int spalte) {
        Performance.getPerformance().lock();
        Performance.getPerformance().freeze();

        try {
            ((Spielfeld) getStage()).checkRow(reihe);
            ((Spielfeld) getStage()).checkCol(spalte);

            if (isLiving(reihe, spalte)) {
                getStage()
                    .remove(getStage()
                                .getComponentsAt(spalte, reihe, Zelle.class)
                                .get(0));
            }
        } finally {
            Performance.getPerformance().unfreeze();
            Performance.getPerformance().unlock();
        }
    }

    @Description("<html>berprft, ob sich die angegebene Zelle (erster Parameter = Reihe,<br>" +
    "zweiter Parameter = Spalte) im Zustand lebendig befindet</html>")
    public boolean isLiving(int reihe, int spalte) {
        Performance.getPerformance().lock();

        try {
            ((Spielfeld) getStage()).checkRow(reihe);
            ((Spielfeld) getStage()).checkCol(spalte);

            return getStage().getComponentsAt(spalte, reihe, Zelle.class).size() > 0;
        } finally {
            Performance.getPerformance().unlock();
        }
    }

}
