import theater.*;


public class Hamster extends Actor {
    protected Solist willi;
    protected int blickrichtung;

    // Default-Konstruktor (muss implementiert werden!)
    public Hamster() {
        super(); // nicht loeschen!
        setImage("hamster.png");

        // hiermit wird dem Solist der Name willi gegeben
        willi = (Solist) this;

        // weitere Initialisierungen
        blickrichtung = 0; // Default = Osten
    }

    // Copy-Konstruktor (muss implementiert werden!)
    public Hamster(Hamster actor) {
        super(actor); // nicht loeschen!

        // hiermit wird dem Solist der Name willi gegeben
        willi = (Solist) this;

        // weitere Initialisierungen
        blickrichtung = actor.blickrichtung;
    }

    @Description("Der Hamster dreht sich um 90 Grad nach links um.")
    public void linksUm() {
        Performance.getPerformance().lock();

        try {
            this.blickrichtung = (this.blickrichtung + 1) % 4;
            this.setRotation(this.getRotation() - 90);
        } finally {
            Performance.getPerformance().unlock();
        }
    }
    
    
    @Description("Der Hamster dreht sich um 180 Grad um.")
    public void umdrehen() {
        Performance.getPerformance().lock();
        Performance.getPerformance().freeze();

        try {
            linksUm();
            linksUm();
        } finally {
            Performance.getPerformance().unfreeze();
            Performance.getPerformance().unlock();
        }
    }

    @Description("Liefert genau dann true, wenn sich vor dem Hamster keine Mauer und " +
    "auch nicht der Rand des Territoriums befindet.")
    public boolean vornFrei() {
        Performance.getPerformance().lock();

        try {
            // ermittle aktuelle Position
            int col = this.getColumn();
            int row = this.getRow();

            // ermittle vorne-Position in Abhaengigkeit von Blickrichtung
            switch (this.blickrichtung) {
            case 0: // Ost
                col++;

                break;

            case 1: // Nord
                row--;

                break;

            case 2: // West
                col--;

                break;

            case 3: // Sued
                row++;

                break;
            }

            // ueberpruefe vorne-Position
            if ((col >= this.getStage().getNumberOfColumns()) ||
                    (row >= this.getStage().getNumberOfRows()) || (col < 0) ||
                    (row < 0)) {
                // Hamster befindet sich am Rand
                return false;
            }

            // Mauer vor dem Hamster?
            return this.getStage().getComponentsAt(col, row, Mauer.class).size() == 0;
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Description("<html>Der Hamster hpft eine Kachel in seiner aktuellen Blickrichtung nach " +
    "vorn.<br>Fehler, wenn sich dort eine Mauer oder der Rand des Territoriums befindet.</html>")
    public void vor() throws MauerDaException {
        Performance.getPerformance().lock();

        try {
            if (!this.vornFrei()) {
                throw new MauerDaException();
            }

            switch (this.blickrichtung) {
            case 0: // Ost
                this.setLocation(this.getColumn() + 1, this.getRow());

                break;

            case 1: // Nord
                this.setLocation(this.getColumn(), this.getRow() - 1);

                break;

            case 2: // West
                this.setLocation(this.getColumn() - 1, this.getRow());

                break;

            case 3: // Sued
                this.setLocation(this.getColumn(), this.getRow() + 1);

                break;
            }
        } finally {
            Performance.getPerformance().unlock();
        }
    }

    @Invisible
    public void setLocation(int col, int row) {
        Performance.getPerformance().lock();

        try {
            if ((col >= 0) && (row >= 0) &&
                    (col < this.getStage().getNumberOfColumns()) &&
                    (row < this.getStage().getNumberOfRows()) &&
                    (this.getStage().getComponentsAt(col, row, Mauer.class)
                             .size() == 0)) {
                // nur innerhalb der sichtbaren Bhne und nur, falls sich auf der
                // angegebenen Kachel keine Mauer befindet
                super.setLocation(col, row);
            }
        } finally {
            Performance.getPerformance().unlock();
        }
    }
}
