package view;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

import listener.Application;
import model.Play;
import util.IO;
import util.PropertyManager;
import util.ResourceManager;
import util.ZipArchives;

public class GenerateDialog extends JDialog {

	private static GenerateDialog instance = null;

	JLabel nameLabel;
	JLabel handbuchOnlineLabel;
	JLabel handbuchOfflineLabel;
	JLabel splashLabel;
	JLabel dirLabel;

	JTextField nameField;
	JTextField handbuchOnlineField;
	JTextField handbuchOfflineField;
	JTextField splashField;
	JTextField dirField;

	JButton handbuchOfflineButton;
	JButton splashButton;
	JButton dirButton;

	JCheckBox debugBox;
	JCheckBox scratchBox;

	public static GenerateDialog getInstance() {
		if (instance == null) {
			instance = new GenerateDialog();
		}
		return instance;
	}

	private GenerateDialog() {
		super(Play.getPlay().getPlayFrame(), ResourceManager
				.getResourceManager().getValue("generate.dialog.title"), true);
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		this.setLayout(new BorderLayout(10, 10));

		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new GridLayout(0, 3, 5, 5));

		mainPanel.add(new JPanel()); // dummy
		mainPanel.add(new JPanel()); // dummy
		mainPanel.add(new JPanel()); // dummy

		this.nameLabel = new JLabel(ResourceManager.getResourceManager()
				.getValue("generate.dialog.name"), JLabel.RIGHT);
		this.nameLabel.setToolTipText(ResourceManager.getResourceManager()
				.getValue("generate.dialog.namedesc"));
		mainPanel.add(this.nameLabel);
		String genName = Play.getPlay().getGenName();
		if (genName == null) {
			genName = "Simulator";
		}
		this.nameField = new JTextField(genName, 12);
		this.nameField.setToolTipText(ResourceManager.getResourceManager()
				.getValue("generate.dialog.namedesc"));
		mainPanel.add(this.nameField);
		mainPanel.add(new JPanel()); // dummy

		this.dirLabel = new JLabel(ResourceManager.getResourceManager()
				.getValue("generate.dialog.dir"), JLabel.RIGHT);
		this.dirLabel.setToolTipText(ResourceManager.getResourceManager()
				.getValue("generate.dialog.dirdesc"));
		mainPanel.add(this.dirLabel);
		this.dirField = new JTextField(12);
		this.dirField.setToolTipText(ResourceManager.getResourceManager()
				.getValue("generate.dialog.dirdesc"));
		mainPanel.add(this.dirField);
		this.dirButton = new JButton(ResourceManager.getResourceManager()
				.getValue("generate.dialog.dirbutton"));
		this.dirButton.setToolTipText(ResourceManager.getResourceManager()
				.getValue("generate.dialog.dirdesc"));
		this.dirButton.addActionListener(new DirChooser(this.dirField));
		mainPanel.add(dirButton);

		mainPanel.add(new JPanel()); // dummy
		mainPanel.add(new JPanel()); // dummy
		mainPanel.add(new JPanel()); // dummy

		this.handbuchOnlineLabel = new JLabel(ResourceManager
				.getResourceManager()
				.getValue("generate.dialog.handbuchonline"), JLabel.RIGHT);
		this.handbuchOnlineLabel.setToolTipText(ResourceManager
				.getResourceManager().getValue(
						"generate.dialog.handbuchonlinedesc"));
		mainPanel.add(this.handbuchOnlineLabel);
		this.handbuchOnlineField = new JTextField(12);
		this.handbuchOnlineField.setToolTipText(ResourceManager
				.getResourceManager().getValue(
						"generate.dialog.handbuchonlinedesc"));
		mainPanel.add(this.handbuchOnlineField);
		mainPanel.add(new JPanel()); // dummy

		this.handbuchOfflineLabel = new JLabel(ResourceManager
				.getResourceManager().getValue(
						"generate.dialog.handbuchoffline"), JLabel.RIGHT);
		this.handbuchOfflineLabel.setToolTipText(ResourceManager
				.getResourceManager().getValue(
						"generate.dialog.handbuchofflinedesc"));
		mainPanel.add(this.handbuchOfflineLabel);
		this.handbuchOfflineField = new JTextField(12);
		this.handbuchOfflineField.setToolTipText(ResourceManager
				.getResourceManager().getValue(
						"generate.dialog.handbuchofflinedesc"));
		mainPanel.add(this.handbuchOfflineField);
		this.handbuchOfflineButton = new JButton(ResourceManager
				.getResourceManager().getValue(
						"generate.dialog.handbuchofflinebutton"));
		this.handbuchOfflineButton.setToolTipText(ResourceManager
				.getResourceManager().getValue(
						"generate.dialog.handbuchofflinedesc"));
		this.handbuchOfflineButton.addActionListener(new ZipChooser(
				this.handbuchOfflineField));
		mainPanel.add(handbuchOfflineButton);

		this.splashLabel = new JLabel(ResourceManager.getResourceManager()
				.getValue("generate.dialog.splash"), JLabel.RIGHT);
		this.splashLabel.setToolTipText(ResourceManager.getResourceManager()
				.getValue("generate.dialog.splashdesc"));
		mainPanel.add(this.splashLabel);
		this.splashField = new JTextField(12);
		this.splashField.setToolTipText(ResourceManager.getResourceManager()
				.getValue("generate.dialog.splashdesc"));
		mainPanel.add(this.splashField);
		this.splashButton = new JButton(ResourceManager.getResourceManager()
				.getValue("generate.dialog.splashbutton"));
		this.splashButton.setToolTipText(ResourceManager.getResourceManager()
				.getValue("generate.dialog.splashdesc"));
		this.splashButton.addActionListener(new ImageChooser(this.splashField));
		mainPanel.add(splashButton);

		mainPanel.add(new JPanel()); // dummy
		mainPanel.add(new JPanel()); // dummy
		mainPanel.add(new JPanel()); // dummy

		mainPanel.add(new JPanel()); // dummy
		this.debugBox = new JCheckBox(ResourceManager.getResourceManager()
				.getValue("generate.dialog.debugging"), true);
		this.debugBox.setToolTipText(ResourceManager.getResourceManager()
				.getValue("generate.dialog.debuggingdesc"));
		mainPanel.add(debugBox);
		mainPanel.add(new JPanel()); // dummy
		
		mainPanel.add(new JPanel()); // dummy
		this.scratchBox = new JCheckBox(ResourceManager.getResourceManager()
				.getValue("generate.dialog.scratch"), false);
		this.scratchBox.setToolTipText(ResourceManager.getResourceManager()
				.getValue("generate.dialog.scratchdesc"));
		mainPanel.add(scratchBox);
		mainPanel.add(new JPanel()); // dummy

		mainPanel.add(new JPanel()); // dummy
		mainPanel.add(new JPanel()); // dummy
		mainPanel.add(new JPanel()); // dummy

		this.add(mainPanel, BorderLayout.CENTER);

		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
		JButton ok = new JButton(ResourceManager.getResourceManager().getValue(
				"generate.dialog.ok"));
		ok.addActionListener(new OKGenAction(this));
		buttonPanel.add(ok);
		JButton cancel = new JButton(ResourceManager.getResourceManager()
				.getValue("generate.dialog.cancel"));
		cancel.addActionListener(new CancelGenAction(this));
		buttonPanel.add(cancel);
		this.add(buttonPanel, BorderLayout.SOUTH);

		this.pack();
		setLocationRelativeTo(Play.getPlay().getPlayFrame());
		this.setResizable(false);
	}

}

class OKGenAction implements ActionListener {

	GenerateDialog dialog;

	OKGenAction(GenerateDialog d) {
		this.dialog = d;
	}

	public void actionPerformed(ActionEvent e) {
		// Ueberpruefen
		String dir = dialog.dirField.getText();
		if (dir == null || dir.trim().equals("")) {
			JOptionPane.showMessageDialog(Play.getPlay().getPlayFrame(),
					ResourceManager.getResourceManager().getValue(
							"msg.invaliddirname"), ResourceManager
							.getResourceManager().getValue("msg.error"),
					JOptionPane.ERROR_MESSAGE);
			return;
		}
		File dirF = new File(dir.trim());
		if (dirF.exists() && dirF.isFile()) {
			JOptionPane.showMessageDialog(Play.getPlay().getPlayFrame(),
					ResourceManager.getResourceManager().getValue(
							"msg.invaliddirname"), ResourceManager
							.getResourceManager().getValue("msg.error"),
					JOptionPane.ERROR_MESSAGE);
			return;
		}

		// handle name
		Play play = Play.getPlay();
		play.setGenName(dialog.nameField.getText());

		// Abspeichern, damit korrekt kopiert wird.
		play.save();

		// handle directory generation
		try {
			if (!dirF.exists()) {
				dirF.mkdirs();
			}
			File to = new File(dirF, Application.SIMULATOR_JAR_NAME);
			IO.copyResMediaFile(Application.SIMULATOR_JAR_NAME, to);

			File dataDir = new File(dirF, "data");
			IO.copyDir(new File(play.getDirectory()), dataDir);
		} catch (Throwable th) {
			th.printStackTrace();
		}

		// handle splash screen
		try {
			String splashName = dialog.splashField.getText();
			if (splashName != null && !splashName.trim().equals("")) {

				File source = new File(splashName);
				File dest = new File(dirF, "splashscreen.png");
				BufferedImage bi = ImageIO.read(source);
				ImageIO.write(bi, "png", dest);
			}
		} catch (Throwable th) {
			th.printStackTrace();
		}

		// handle Property-File
		PrintStream out = null;
		try {
			File dest = new File(dirF, PropertyManager.PROP_FILE);
			out = new PrintStream(new BufferedOutputStream(
					new FileOutputStream(dest)));

			out.println(PropertyManager.PROP_JDK + "=");

			out.println(PropertyManager.PROP_INITHEAPSPACE + "="
					+ PropertyManager.getPropertyManager().getInitHeapSpaceP());
			out.println(PropertyManager.PROP_MAXHEAPSPACE + "="
					+ PropertyManager.getPropertyManager().getMaxHeapSpaceP());

			String onoff = dialog.debugBox.isSelected() ? "on" : "off";
			out.println(PropertyManager.PROP_DEBUGGING + "=" + onoff);
			
			String scratchTrue = dialog.scratchBox.isSelected() ? "true" : "false";
			out.println(PropertyManager.PROP_SCRATCH + "=" + scratchTrue);

			if (dialog.handbuchOnlineField.getText() != null
					&& !dialog.handbuchOnlineField.getText().trim().equals("")) {
				out.println(PropertyManager.PROP_HANDBOOK_ONLINE + "="
						+ dialog.handbuchOnlineField.getText());
			} else {
				out.println(PropertyManager.PROP_HANDBOOK_ONLINE + "=");
			}

			String oUrl = dialog.handbuchOfflineField.getText();
			if (oUrl != null && !oUrl.trim().equals("")) {
				if (oUrl.endsWith(".zip")) {
					File handbookDir = new File(dirF, "handbuch");
					ZipArchives.unzip(new File(oUrl),
							handbookDir);
					out.println(PropertyManager.PROP_HANDBOOK_OFFLINE + "="
							+ handbookDir.getName() + "/" + "index.html");
				} else {
					File choosenFile = new File(oUrl);
					File handbookDir = new File(dirF, "handbuch");
					handbookDir.mkdir();
					File handbookFile = new File(dirF, "handbuch/handbuch.pdf");
					IO.copyMediaFile(choosenFile, handbookFile);
					out.println(PropertyManager.PROP_HANDBOOK_OFFLINE + "="
							+ "handbuch/handbuch.pdf");
				}
			}

		} catch (Throwable th) {
			th.printStackTrace();
		} finally {
			if (out != null) {
				out.close();
			}
		}

		this.dialog.dispose();
		Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				ResourceManager.getResourceManager().getValue(
						"msg.simgenerated"));
	}
}

class CancelGenAction implements ActionListener {

	JDialog dialog;

	CancelGenAction(JDialog d) {
		this.dialog = d;
	}

	public void actionPerformed(ActionEvent e) {
		this.dialog.dispose();
		Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				ResourceManager.getResourceManager().getValue(
						"msg.actioncanceled"));
	}

}

class DirChooser implements ActionListener {

	JTextField field;

	DirChooser(JTextField field) {
		this.field = field;
	}

	public void actionPerformed(ActionEvent e) {
		JFileChooser chooser = new JFileChooser();
		chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		int returnVal = chooser.showDialog(Play.getPlay().getPlayFrame(),
				ResourceManager.getResourceManager().getValue("choose"));
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			field.setText(chooser.getSelectedFile().getAbsolutePath());
		}

	}
}

class ZipChooser implements ActionListener {

	JTextField field;

	ZipChooser(JTextField field) {
		this.field = field;
	}

	public void actionPerformed(ActionEvent e) {
		JFileChooser chooser = new JFileChooser();
		FileFilter filter = new ZipPdfFilter();
		chooser.setFileFilter(filter);
		int returnVal = chooser.showDialog(Play.getPlay().getPlayFrame(),
				ResourceManager.getResourceManager().getValue("choose"));
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			field.setText(chooser.getSelectedFile().getAbsolutePath());
		}

	}
}

class ImageChooser implements ActionListener {

	JTextField field;

	ImageChooser(JTextField field) {
		this.field = field;
	}

	public void actionPerformed(ActionEvent e) {
		JImageChooser chooser = JImageChooser.getInstance();
		chooser.setMultiSelectionEnabled(false);
		chooser.setSelectedFile(null);
		int returnVal = chooser.showDialog(Play.getPlay().getPlayFrame(),
				ResourceManager.getResourceManager().getValue("choose"));
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			String str = chooser.getSelectedFile().getAbsolutePath();
			field.setText(str);
		}
	}
}

class ZipPdfFilter extends FileFilter {

	public boolean accept(File f) {
		if (f.isDirectory()) {
			return true;
		}
		return f.getName().toLowerCase().endsWith(".zip")
				|| f.getName().toLowerCase().endsWith(".pdf");
	}

	public String getDescription() {
		return "zip, pdf";
	}

}
