package scratch.elements.booleans;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

import scratch.Renderable.Type;
import scratch.elements.BooleanMethodObject;
import theater.Component;
import theater_intern.IComponent;
import view.ComponentPopupMenu;
import view.MethodComparator;

public class DynBooleanObjects extends ArrayList<BooleanObjectMethod> {

	protected DynBooleanObjects() {
		super();
	}

	private static DynBooleanObjects obj = null;

	public static DynBooleanObjects getObject() {
		if (obj == null) {
			obj = new DynBooleanObjects();
		}
		return obj;
	}

	public void addBooleanObject(String name, Method m) {
		BooleanMethodObject obj = new BooleanMethodObject(name,
				new ArrayList<Type>());
		add(new BooleanObjectMethod(obj, m));
	}

	public boolean containsElement(String name) {
		for (BooleanObjectMethod om : this) {
			if (om.obj.getName().equals(name)) {
				return true;
			}
		}
		return false;
	}

	public BooleanMethodObject getBooleanObject(String name) {
		for (BooleanObjectMethod om : this) {
			if (om.obj.getName().equals(name)) {
				return om.obj;
			}
		}
		return null;
	}

	public boolean containsBooleanMethodObject(Method method) {
		for (BooleanObjectMethod om : this) {
			if (om.method.equals(method)) {
				return true;
			}
		}
		return false;
	}

	public ArrayList<BooleanMethodObject> getBooleanObjects() {
		ArrayList<BooleanMethodObject> res = new ArrayList<BooleanMethodObject>();
		for (BooleanObjectMethod om : this) {
			res.add(om.obj);
		}
		return res;
	}

	public ArrayList<String> getNames() {
		ArrayList<String> res = new ArrayList<String>();
		for (BooleanObjectMethod om : this) {
			res.add(om.obj.getName());
		}
		return res;
	}

	public Method getMethod(String name) {
		for (BooleanObjectMethod om : this) {
			if (om.obj.getName().equals(name)) {
				return om.method;
			}
		}
		return null;
	}

	public void fill(IComponent icomp) {
		this.clear();
		MethodComparator comparator = new MethodComparator();
		Component comp = IComponent.getComp(icomp);
		Class<?> cls = comp.getClass();
		cls = cls.getSuperclass();
		Method[] methods = ComponentPopupMenu.getScratchBooleanMethods(comp,
				cls);
		Arrays.sort(methods, comparator);
		for (Method method : methods) {
			String name = ComponentPopupMenu.genScratchMethodName(method);
			addBooleanObject(name, method);
		}
	}

}

class BooleanObjectMethod {
	BooleanMethodObject obj;
	Method method;

	BooleanObjectMethod(BooleanMethodObject o, Method m) {
		this.obj = o;
		this.method = m;
	}
}
