package view;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import model.ActionButton;
import model.Play;
import util.IO;
import util.ResourceManager;
import util.Utils;

import compiler.CompileManager;

public class NewActionButtonDialog extends JDialog {

	JTextField name;
	JComboBox type;

	static final String[] types = { ActionButton.ACTION_HANDLER,
			ActionButton.NEWPROP_HANDLER, ActionButton.CLICK_HANDLER };

	public NewActionButtonDialog(JFrame frame) {
		super(frame, ResourceManager.getResourceManager().getValue(
				"actionbutton.dialog.title"), true);
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		this.setLayout(new BorderLayout());

		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new FlowLayout(FlowLayout.CENTER));

		JLabel n = new JLabel(ResourceManager.getResourceManager().getValue(
				"actionbutton.dialog.name"));
		mainPanel.add(n);

		this.name = new JTextField(15);
		this.name.addActionListener(new OKAction(this));
		mainPanel.add(name);

		JLabel t = new JLabel(ResourceManager.getResourceManager().getValue(
				"actionbutton.dialog.type"));
		mainPanel.add(t);

		DefaultComboBoxModel m = new DefaultComboBoxModel(types);
		type = new JComboBox(m);
		mainPanel.add(type);

		this.add(mainPanel, BorderLayout.CENTER);

		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
		JButton ok = new JButton(ResourceManager.getResourceManager().getValue(
				"actionbutton.dialog.ok"));
		ok.addActionListener(new OKAction(this));
		buttonPanel.add(ok);
		JButton cancel = new JButton(ResourceManager.getResourceManager()
				.getValue("actionbutton.dialog.cancel"));
		cancel.addActionListener(new CancelAction(this));
		buttonPanel.add(cancel);
		this.add(buttonPanel, BorderLayout.SOUTH);

		this.pack();
		setLocationRelativeTo(frame);
		this.setResizable(false);
	}

}

class OKAction implements ActionListener {

	NewActionButtonDialog dialog;

	OKAction(NewActionButtonDialog d) {
		this.dialog = d;
	}

	public void actionPerformed(ActionEvent e) {
		if (!Utils.checkClassName(dialog.name.getText())) {
			JOptionPane.showMessageDialog(Play.getPlay().getPlayFrame(),
					ResourceManager.getResourceManager().getValue(
							"msg.invalidname"), ResourceManager
							.getResourceManager().getValue("msg.error"),
					JOptionPane.ERROR_MESSAGE);
			return;
		}
		ActionButton button = new ActionButton(dialog.name.getText(),
				NewActionButtonDialog.types[dialog.type.getSelectedIndex()]);
		Play.getPlay().getPlayFrame().addActionButtonToToolbar(button, true);
		createNewActionButtonClass(button);
		CompileManager.getCompileManager().setCompilationRequired(true);

		this.dialog.dispose();
		
		Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				ResourceManager.getResourceManager().getValue(
						"msg.actionbutton.new"));
	}

	private void createNewActionButtonClass(ActionButton button) {
		try {
			Play play = Play.getPlay();
			File file = new File(play.getDirectory() + File.separatorChar
					+ button.getName() + ".java");
			file.createNewFile();
			IO.copyResTextFile(button.getType() + ".txt", file.getAbsolutePath(), button
					.getName());
			play.insertActionButtonClass(button.getName(), button);
		} catch (Throwable exc) {
			exc.printStackTrace();
		}
	}
}

class CancelAction implements ActionListener {

	JDialog dialog;

	CancelAction(JDialog d) {
		this.dialog = d;
	}

	public void actionPerformed(ActionEvent e) {
		this.dialog.dispose();
		Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
				ResourceManager.getResourceManager().getValue(
						"msg.actioncanceled"));
	}

}
