package simulation;

import java.util.Observable;

import listener.StoppedMouseListener;
import model.Play;
import simulation.listener.SimulationMouseListener;
import simulation.listener.TheaterKeyListener;
import theater.Performance;
import theater_intern.IPerformance;
import theater_intern.StateChange;
import theater_intern.TheaterObserver;
import view.StagePanel;

/**
 * ber diese Klasse werden Interessierte, wie das StagePanel ber nderungen
 * des Modells informiert
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class ActTheaterObserver extends TheaterObserver {

	public ActTheaterObserver() {
		super();
	}

	public void update(Observable o, Object arg) {
		IPerformance iPerf = Play.getPlay().getActivePerformance();

		StagePanel panel = Play.getPlay().getStagePanel();
		if (arg == StateChange.IMPORTANT_CHANGE) {
			if (!iPerf.frozen()) {
				panel.repaintStage();
				// diboxy Play.getPlay().getPlayFrame().getFileTree().repaint();
				if (iPerf.simulationRunning()) {
					sleep();
				}
			}
		} else if (arg == StateChange.SINGLE_CHANGE) {
			if (!iPerf.frozen()) {
				panel.repaintStage();
				if (iPerf.simulationRunning()) {
					sleep();
				}
			}
		} else if (arg == StateChange.CYCLE_END) {
			if (!iPerf.frozen()) {
				panel.repaintStage();
			}
		} else if (arg == StateChange.PERFORMANCE_CHANGE) {
			if (iPerf.simulationRunning()) {
				panel.setMouseListener(new SimulationMouseListener());
				panel.setKeyListener(new TheaterKeyListener());
				panel.requestFocusInWindow();
			} else { // if (iPerf.simulationStopped()) {
				panel.setMouseListener(new StoppedMouseListener());
				panel.setKeyListener(null);
			}
		}

	}

	void sleep() {
		if (Play.getPlay().getActivePerformance().isStepRequest()) {
			return;
		}
		try {
			double speed = Play.getPlay().getActivePerformance()
					.getSimulationSpeed();
			if (speed <= 0) {
				speed = 0.5;
			}
			int value = (int) ((-Math.log(speed) + Math
					.log(Performance.MAX_SPEED)) * 200);
			Thread.sleep(value);
		} catch (InterruptedException exc) {
			Thread.currentThread().interrupt();
		}
	}
}
