package compiler;

/**
 * Reprsentiert eine Fehlermeldung eines Compilers
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class ErrorMessage {
	private String filename;
	private String msg;
	private long line;

	/**
	 * Erzeugt eine Fehlermeldung; bergeben wird der Dateiname und die Meldung
	 * 
	 * @param filename
	 * @param msg
	 */
	public ErrorMessage(String filename, String msg, int line) {
		this.filename = filename;
		this.msg = msg;
		this.line = line;
	}

	/**
	 * Erzeugt eine (nicht initialisierte) Fehlermeldung
	 */
	public ErrorMessage() {
		this.filename = null;
		this.msg = null;
		this.line = -1;
	}

	/**
	 * Liefert den Dateinamen
	 * 
	 * @return
	 */
	public String getFilename() {
		return filename;
	}

	/**
	 * Setzt den Dateinamen
	 * 
	 * @param filename
	 */
	/**
	 * @param filename
	 */
	public void setFilename(String filename) {
		this.filename = filename;
	}

	/**
	 * Liefert die Meldung
	 * 
	 * @return
	 */
	public String getMsg() {
		return msg;
	}

	/**
	 * Setzt die Meldung
	 * 
	 * @param msg
	 */
	public void setMsg(String msg) {
		this.msg = msg;
	}

	public long getLine() {
		return line;
	}

	public void setLine(long line) {
		this.line = line;
	}

	public String getProblem() {
		String problem = new String(this.msg);
		int i = problem.indexOf(this.filename);
		if (i >= 0) { // entfernt den Dateinamen-Prfix aus der Fehlermeldung
			problem = problem.substring(i);
		} else {
			return this.msg;
		}

		i = problem.indexOf(":");
		if (i >= 0) { // entfernt den Dateinamen
			problem = problem.substring(i + 1);
		} else {
			return this.msg;
		}

		i = problem.indexOf(":");
		if (i >= 0) { // entfernt die Zeilennummer
			problem = problem.substring(i + 1);
		} else {
			return this.msg;
		}

		return problem;
	}

}
