package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;

import javax.swing.AbstractButton;
import javax.swing.JOptionPane;

import model.ActionButton;
import model.ActionButtonClass;
import model.ClassManager;
import model.Play;
import theater.ActionHandler;
import theater.ClickHandler;
import theater.Component;
import theater.NewPropHandler;
import theater.Performance;
import theater.Point;
import util.SolistThread;
import util.Utils;
import view.NewPropButton;
import view.StagePanel;

import compiler.CompileManager;

public class ActionButtonListener implements ActionListener {

	ActionButton button;
	boolean selected;

	public ActionButtonListener(ActionButton b) {
		this.button = b;
		this.selected = false;
	}

	public void actionPerformed(final ActionEvent e) {
		try {
			Class<?> cls = CompileManager.getCompileManager().getClassLoader()
					.loadClass(button.getName());
			final Object obj = cls.newInstance();
			if (Utils.dynInstanceof(obj, ActionHandler.class)) {
				ActionButton.group.clearSelection();
				unselectOther();
				final ActionHandler handler = (ActionHandler) obj;
				new SolistThread(new Runnable() {
					public void run() {
						Performance.getPerformance().lock();
						try {
							handler.handleAction(Performance.getPerformance()
									.getActiveStage(), Performance
									.getPerformance().getActiveStage()
									.getSolist());
						} catch (Throwable th) {
							th.printStackTrace();
							JOptionPane.showMessageDialog(Play.getPlay()
									.getStagePanel(), th.toString(), th
									.getClass().getName(),
									JOptionPane.ERROR_MESSAGE);
						} finally {
							Performance.getPerformance().unlock();
						}
					}
				}).call();
			} else if (Utils.dynInstanceof(obj, NewPropHandler.class)) {
				ActionButton.group.clearSelection();
				unselectOther();
				NewPropHandler handler = (NewPropHandler) obj;
				NewPropButton button = (NewPropButton) e.getSource();
				Play.getPlay().getPlayFrame().getGlassPane().activate(handler,
						button);
			} else if (Utils.dynInstanceof(obj, ClickHandler.class)) {
				ClickHandler handler = (ClickHandler) obj;
				AbstractButton b = button.getJButton();
				if (selected && b.isSelected()) {
					ActionButton.group.clearSelection();
					unselect();
				} else {
					if (b.isSelected()) {
						selected = true;
						unselectOther();
						ClickListener clickL = new ClickListener(handler);
						button.setClickListener(clickL);
						Play.getPlay().getStagePanel().addMouseListener(clickL);
					} else {
						unselect();
					}
				}
			}
		} catch (Throwable th) {
			th.printStackTrace();
		}
	}

	public void unselectOther() {
		for (String className : Play.getPlay().getActionButtonClasses()) {
			ActionButtonClass cl2 = (ActionButtonClass) ClassManager
					.getClassManager().getClass(className);
			ActionButtonListener l = cl2.getActionButton()
					.getActionButtonListener();
			if (l != this) {
				l.unselect();
			}
		}
	}
	
	public static void unselectAll() {
		for (String className : Play.getPlay().getActionButtonClasses()) {
			ActionButtonClass cl2 = (ActionButtonClass) ClassManager
					.getClassManager().getClass(className);
			ActionButtonListener l = cl2.getActionButton()
					.getActionButtonListener();
				l.unselect();
		}
	}

	public void unselect() {
		selected = false;
		MouseAdapter clickL = this.button.getClickListener();
		if (clickL != null) {
			Play.getPlay().getStagePanel().removeMouseListener(clickL);
			this.button.setClickListener(null);
		}
	}

}

class ClickListener extends MouseAdapter {

	ClickHandler handler;

	ClickListener(ClickHandler handler) {
		this.handler = handler;
	}

	public void mousePressed(MouseEvent e) {
		StagePanel stagePanel = Play.getPlay().getStagePanel();
		if (stagePanel.isInsideStage(e.getPoint())) {
			final int col = stagePanel.getCellColumn(e.getX());
			final int row = stagePanel.getCellRow(e.getY());
			int stageX = stagePanel.getStageX(e.getX());
			int stageY = stagePanel.getStageY(e.getY());
			final Point p = new Point(stageX, stageY);
			new SolistThread(new Runnable() {
				public void run() {
					Performance.getPerformance().lock();
					try {
						List<Component> inters = Performance.getPerformance()
								.getActiveStage().getIntersectingComponents(p);
						handler
								.handleClick(Performance.getPerformance()
										.getActiveStage(), Performance
										.getPerformance().getActiveStage()
										.getSolist(), col, row, inters);
					} catch (Throwable th) {
						th.printStackTrace();
						JOptionPane.showMessageDialog(Play.getPlay()
								.getStagePanel(), th.toString(), th.getClass()
								.getName(), JOptionPane.ERROR_MESSAGE);
					} finally {
						Performance.getPerformance().unlock();
					}
				}
			}).call();
		}
	}

}
