package compiler;

import java.io.IOException;

public class JavaImportHandler {
	int pos;

	public JavaImportHandler() {
	}

	public JavaToken nextToken(JavaLexer lexer) throws IOException {
		JavaToken t = lexer.nextToken();
		while (t != null && (t.isComment() | t.isWhiteSpace()))
			t = lexer.nextToken();
		return t;
	}

	public String handleImport(String prefix, String code, String postfix)
			throws IOException {
		String result = "";
		JavaLexer lexer = new JavaLexer();
		lexer.init(0, 0, code);
		int pos = 0;

		JavaToken t = nextToken(lexer);

		boolean withImport = false;
		// imports
		while (t != null && t.getText().equals("import")) {
			withImport = true;
			t = nextToken(lexer);
			while (t != null && !t.getText().equals(";"))
				t = nextToken(lexer);
			t = nextToken(lexer);
		}

		if (withImport) {
			result += code.substring(pos, t.getStart());
			result += prefix;
			result += code.substring(t.getStart(), code.length());
			result += postfix;
		} else {
			result += prefix;
			result += code;
			result += postfix;
		}

		return result;
	}
}
