package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.List;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import model.Play;
import theater.Actor;
import theater.Component;
import theater.Internal;
import theater.Stage;
import util.ResourceManager;
import util.Utils;

import compiler.CompileManager;

public class LoadStageListener implements ActionListener {

	public void actionPerformed(ActionEvent e) {
		JFileChooser chooser = SaveProgramListener.getFileChooser();
		int returnVal = chooser.showOpenDialog(Play.getPlay().getPlayFrame());
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			File from = chooser.getSelectedFile();
			if (loadStage(from)) {
				Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.stage.loaded"));
			}
		} else {
			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.actioncanceled"));
		}
	}

	public static boolean loadStage(File from) {
		try {

			FileInputStream fs = new FileInputStream(from);
			TheaterInputStream is = new TheaterInputStream(fs);

			Stage stage = (Stage) is.readObject();
			List<Component> components = (List<Component>) is.readObject();

			Actor solist = getSolist(components);

			Internal.reInit(stage, solist, components);

			is.close();
			return true;
		} catch (Throwable th) {
			th.printStackTrace();
			JOptionPane.showMessageDialog(Play.getPlay().getPlayFrame(),
					ResourceManager.getResourceManager().getValue(
							"loader.loadstagenotpossible"), ResourceManager
							.getResourceManager().getValue("msg.error"),
					JOptionPane.ERROR_MESSAGE);
			return false;
		}
	}

	static Actor getSolist(List<Component> components) {
		for (Component comp : components) {
			if (Utils.dynInstanceof(comp, Actor.class)) {
				return (Actor) comp;
			}
		}
		return null;
	}

}

class TheaterInputStream extends ObjectInputStream {

	public TheaterInputStream(FileInputStream fs) throws IOException {
		super(fs);
	}

	protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException,
			ClassNotFoundException {
		String name = desc.getName();
		try {
			return super.resolveClass(desc);
		} catch (ClassNotFoundException ex) {
			return Class.forName(name, false, CompileManager
					.getCompileManager().getClassLoader());
		}
	}
}
