package view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;

import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

import model.ActionButton;
import model.ClassManager;
import model.Play;
import util.ResourceManager;
import editor.Editor;

/**
 * Popup-Menu fr die Ordner im JTree
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class ActionButtonPopupMenu extends JPopupMenu {

	int x;
	int y;

	public ActionButtonPopupMenu(ActionButton button) {
		super();

		JMenuItem iconItem = new JMenuItem(ResourceManager.getResourceManager()
				.getValue("actionbutton.popup.icon")
				+ " ...");
		iconItem.addActionListener(new ChangeIconAction(button));
		this.add(iconItem);

		JMenuItem tooltipIcon = new JMenuItem(ResourceManager
				.getResourceManager().getValue("actionbutton.popup.tooltip")
				+ " ...");
		tooltipIcon.addActionListener(new ChangeTooltipAction(button));
		this.add(tooltipIcon);

		JMenuItem editorItem = new JMenuItem(ResourceManager
				.getResourceManager().getValue("actionbutton.popup.editor")
				+ " ...");
		editorItem.addActionListener(new OpenEditorAction(button, this));
		this.add(editorItem);

		this.addSeparator();

		JMenuItem deleteIcon = new JMenuItem(ResourceManager
				.getResourceManager().getValue("actionbutton.popup.delete"));
		deleteIcon.addActionListener(new DeleteButtonAction(button));
		this.add(deleteIcon);

		JMenu moveMenu = new JMenu(ResourceManager.getResourceManager()
				.getValue("actionbutton.popup.move"));
		JMenuItem leftIcon = new JMenuItem(ResourceManager.getResourceManager()
				.getValue("actionbutton.popup.left"));
		leftIcon.addActionListener(new MoveLeftAction(button));
		moveMenu.add(leftIcon);
		JMenuItem rightIcon = new JMenuItem(ResourceManager
				.getResourceManager().getValue("actionbutton.popup.right"));
		rightIcon.addActionListener(new MoveRightAction(button));
		moveMenu.add(rightIcon);
		this.add(moveMenu);
	}

	public void setXY(int x, int y) {
		this.x = x;
		this.y = y;
	}
}

class ChangeTooltipAction implements ActionListener {

	ActionButton button;

	ChangeTooltipAction(ActionButton b) {
		this.button = b;
	}

	public void actionPerformed(ActionEvent e) {
		String tip = button.getTooltip();
		String input = null;
		if (tip != null) {
			input = JOptionPane
					.showInputDialog(null, ResourceManager.getResourceManager()
							.getValue("actionbutton.tooltip"), tip);
		} else {
			input = JOptionPane.showInputDialog(ResourceManager
					.getResourceManager().getValue("actionbutton.tooltip"));
		}
		if (input != null) {
			this.button.setTooltip(input);
			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.actionbutton.tooltipset"));
		} else {
			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.actioncanceled"));
		}

	}

}

class ChangeIconAction implements ActionListener {

	ActionButton button;
	JImageChooser chooser;

	ChangeIconAction(ActionButton b) {
		this.button = b;
		String path = Play.getPlay().getDirectory() + File.separatorChar
				+ "images";
		this.chooser = JImageChooser.getPlayInstance(path);
	}

	public void actionPerformed(ActionEvent e) {
		int returnVal = this.chooser.showDialog(Play.getPlay().getPlayFrame(),
				ResourceManager.getResourceManager().getValue(
						"actionbutton.icon"));
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			File file = this.chooser.getSelectedFile();
			this.button.setIconFilename(file.getName());
			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.actionbutton.iconset"));
		} else {
			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.actioncanceled"));
		}
	}

}

class DeleteButtonAction implements ActionListener {

	ActionButton button;

	DeleteButtonAction(ActionButton b) {
		this.button = b;

	}

	public void actionPerformed(ActionEvent e) {
		int answer = JOptionPane.showConfirmDialog(Play.getPlay()
				.getPlayFrame(), ResourceManager.getResourceManager().getValue(
				"actionbutton.delete"), ResourceManager.getResourceManager()
				.getValue("msg.request"), JOptionPane.YES_NO_OPTION);
		if (answer == JOptionPane.YES_OPTION) {
			button.delete();
			Play play = Play.getPlay();

			String name = this.button.getName();
			Editor editor = ClassManager.getClassManager().getClass(name)
					.getEditor();
			editor.close();

			File file = new File(play.getDirectory() + File.separatorChar
					+ name + ".class");
			file.delete();
			file = new File(play.getDirectory() + File.separatorChar + name
					+ ".java");
			file.delete();

			play.getPlayFrame().removeActionButtonFromToolbar(button, true);
			Play.getPlay().removeActionButtonClass(button.getName());

			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.actionbutton.deleted"));

		} else {
			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.actioncanceled"));
		}
	}

}

class OpenEditorAction implements ActionListener {

	ActionButton button;
	ActionButtonPopupMenu menu;

	OpenEditorAction(ActionButton b, ActionButtonPopupMenu menu) {
		this.button = b;
		this.menu = menu;
	}

	public void actionPerformed(ActionEvent e) {
		open();
	}

	private void open() {
		Editor editor = ClassManager.getClassManager().getClass(
				button.getName()).getEditor();
		if (!editor.isOpen()) {
			editor.setLocation(Math.max(20, menu.x - editor.getWidth() / 2),
					Math.max(20, menu.y - editor.getHeight() / 2));
			editor.open();
		}
		editor.toFront();
	}

}

class MoveLeftAction implements ActionListener {

	ActionButton button;

	MoveLeftAction(ActionButton b) {
		this.button = b;
	}

	public void actionPerformed(ActionEvent e) {
		ArrayList<String> buttons = Play.getPlay().getActionButtonClasses();
		String name = button.getName();
		if (buttons.get(0).equals(name)) {
			return;
		}
		for (int i = 1; i < buttons.size(); i++) {
			if (buttons.get(i).equals(name)) {
				buttons.remove(i);
				buttons.add(i - 1, name);
				Play.getPlay().getPlayFrame().repaintActionButtons();
				Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.actionbutton.moved"));
				return;
			}
		}
	}
}

class MoveRightAction implements ActionListener {

	ActionButton button;

	MoveRightAction(ActionButton b) {
		this.button = b;
	}

	public void actionPerformed(ActionEvent e) {
		ArrayList<String> buttons = Play.getPlay().getActionButtonClasses();
		String name = button.getName();
		if (buttons.get(buttons.size() - 1).equals(name)) {
			return;
		}
		for (int i = 0; i < buttons.size() - 1; i++) {
			if (buttons.get(i).equals(name)) {
				buttons.remove(i);
				buttons.add(i + 1, name);
				Play.getPlay().getPlayFrame().repaintActionButtons();
				Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.actionbutton.moved"));
				return;
			}
		}
	}
}
