package util;

import java.io.File;
import java.util.List;

import model.Play;

//import com.sun.tools.javadoc.*;
//public class Probe {
//
//	/**
//	 * hallo
//	 * 
//	 * @param args
//	 */
//	public static void main(String[] args) {
//		Main.execute("hallo", new String[] { "-d", "docs", "-sourcepath", ".",
//				"Probe.java" });
//	}
//
//}

public class JavadocGenerator {

	public void javadocGenerator() {
		String directory = Play.getPlay().getDirectory();
		String classname = Play.getPlay().getActiveActorName();
		final ProcessBuilder builder = new ProcessBuilder("javadoc", "-quiet",
				"-public", "-noindex", "-nohelp", "-nonavbar", "-notree",
				"-d", "\"" + directory + File.separatorChar + "javadoc" + "\"",
				"-sourcepath", "\".;" + directory + "\"", "\"" + directory
						+ File.separatorChar + classname + ".java" + "\"");
		List<String> l = builder.command();
		for (String s : l) {
			System.out.print(s + " ");
		}
		System.out.println();

		Thread t = new Thread(new Runnable() {
			public void run() {
				Process p = null;
				try {
					p = builder.start();
					p.waitFor();
				} catch (ThreadDeath d) {
					if (p != null) {
						p.destroy();
						System.out.println("destroyed");
					}
				} catch (Throwable e) {
					e.printStackTrace();
				}
			}
		});
		t.start();
		try {
			t.join(5000);
		} catch (InterruptedException exc) {
		}
		if (t.isAlive()) {
			System.out.println("hat nicht geklappt");
			t.stop();
			try {
				t.join();
			} catch (InterruptedException e) {
			}
		}

	}
}
